/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.form.StartFormData;
import org.flowable.engine.impl.form.FormEngine;
import org.flowable.engine.impl.form.StartFormHandler;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.impl.util.FormHandlerUtil;
import org.flowable.engine.repository.ProcessDefinition;

public class GetRenderedStartFormCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected String formEngineName;

    public GetRenderedStartFormCmd(String processDefinitionId, String formEngineName) {
        this.processDefinitionId = processDefinitionId;
        this.formEngineName = formEngineName;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        ProcessDefinition processDefinition = commandContext.getProcessEngineConfiguration().getDeploymentManager().findDeployedProcessDefinitionById(this.processDefinitionId);
        if (processDefinition == null) {
            throw new FlowableObjectNotFoundException("Process Definition '" + this.processDefinitionId + "' not found", ProcessDefinition.class);
        }
        if (Flowable5Util.isFlowable5ProcessDefinition(processDefinition, commandContext)) {
            return Flowable5Util.getFlowable5CompatibilityHandler().getRenderedStartForm(this.processDefinitionId, this.formEngineName);
        }
        StartFormHandler startFormHandler = FormHandlerUtil.getStartFormHandler(commandContext, processDefinition);
        if (startFormHandler == null) {
            return null;
        }
        FormEngine formEngine = commandContext.getProcessEngineConfiguration().getFormEngines().get(this.formEngineName);
        if (formEngine == null) {
            throw new FlowableException("No formEngine '" + this.formEngineName + "' defined process engine configuration");
        }
        StartFormData startForm = startFormHandler.createStartFormData(processDefinition);
        return formEngine.renderStartForm(startForm);
    }
}

