/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.task.Task;

public class GetTaskVariablesCmd
implements Command<Map<String, Object>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected Collection<String> variableNames;
    protected boolean isLocal;

    public GetTaskVariablesCmd(String taskId, Collection<String> variableNames, boolean isLocal) {
        this.taskId = taskId;
        this.variableNames = variableNames;
        this.isLocal = isLocal;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new FlowableIllegalArgumentException("taskId is null");
        }
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        if (task == null) {
            throw new FlowableObjectNotFoundException("task " + this.taskId + " doesn't exist", Task.class);
        }
        if (this.variableNames == null) {
            if (this.isLocal) {
                return task.getVariablesLocal();
            }
            return task.getVariables();
        }
        if (this.isLocal) {
            return task.getVariablesLocal(this.variableNames, false);
        }
        return task.getVariables(this.variableNames, false);
    }
}

