/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.JobNotFoundException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.AbstractJobEntity;
import org.flowable.engine.impl.persistence.entity.DeadLetterJobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveJobToDeadLetterJobCmd
implements Command<DeadLetterJobEntity>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(MoveJobToDeadLetterJobCmd.class);
    protected String jobId;

    public MoveJobToDeadLetterJobCmd(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public DeadLetterJobEntity execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new FlowableIllegalArgumentException("jobId and job is null");
        }
        AbstractJobEntity job = (AbstractJobEntity)commandContext.getTimerJobEntityManager().findById(this.jobId);
        if (job == null) {
            job = (AbstractJobEntity)commandContext.getJobEntityManager().findById(this.jobId);
        }
        if (job == null) {
            throw new JobNotFoundException(this.jobId);
        }
        if (log.isDebugEnabled()) {
            log.debug("Moving job to deadletter job table {}", (Object)job.getId());
        }
        DeadLetterJobEntity deadLetterJob = commandContext.getJobManager().moveJobToDeadLetterJob(job);
        return deadLetterJob;
    }

    public String getJobId() {
        return this.jobId;
    }
}

