/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.DeploymentBuilder;
import org.flowable.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedeployV5ProcessDefinitionsCmd
implements Command<Void> {
    private static final Logger logger = LoggerFactory.getLogger(RedeployV5ProcessDefinitionsCmd.class);

    @Override
    public Void execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        RepositoryService repositoryService = processEngineConfiguration.getRepositoryService();
        List processDefinitions = repositoryService.createProcessDefinitionQuery().latestVersion().processDefinitionEngineVersion("v5").list();
        if (!processDefinitions.isEmpty()) {
            ArrayList<String> deploymentIds = new ArrayList<String>();
            HashMap deploymentMap = new HashMap();
            for (ProcessDefinition processDefinition : processDefinitions) {
                if (!deploymentIds.contains(processDefinition.getDeploymentId())) {
                    deploymentIds.add(processDefinition.getDeploymentId());
                }
                List<ProcessDefinition> groupedProcessDefinitions = null;
                groupedProcessDefinitions = deploymentMap.containsKey(processDefinition.getDeploymentId()) ? (List)deploymentMap.get(processDefinition.getDeploymentId()) : new ArrayList<ProcessDefinition>();
                groupedProcessDefinitions.add(processDefinition);
                deploymentMap.put(processDefinition.getDeploymentId(), groupedProcessDefinitions);
            }
            List deployments = repositoryService.createDeploymentQuery().deploymentIds(deploymentIds).list();
            for (Deployment deployment : deployments) {
                DeploymentBuilder deploymentBuilder = repositoryService.createDeployment();
                if (deployment.getName() != null) {
                    deploymentBuilder.name(deployment.getName());
                }
                if (deployment.getCategory() != null) {
                    deploymentBuilder.category(deployment.getCategory());
                }
                if (deployment.getKey() != null) {
                    deploymentBuilder.key(deployment.getKey());
                }
                if (deployment.getTenantId() != null) {
                    deploymentBuilder.tenantId(deployment.getTenantId());
                }
                List groupedProcessDefinitions = (List)deploymentMap.get(deployment.getId());
                for (ProcessDefinition processDefinition : groupedProcessDefinitions) {
                    logger.info("adding v5 process definition with id: {} and key: {} for redeployment", (Object)processDefinition.getId(), (Object)processDefinition.getKey());
                    InputStream definitionStream = repositoryService.getResourceAsStream(deployment.getId(), processDefinition.getResourceName());
                    deploymentBuilder.addInputStream(processDefinition.getResourceName(), definitionStream);
                }
                deploymentBuilder.deploy();
            }
        }
        return null;
    }
}

