/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.context;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import org.flowable.engine.FlowableEngineAgenda;
import org.flowable.engine.common.impl.cfg.BaseTransactionContext;
import org.flowable.engine.common.impl.transaction.TransactionContextHolder;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cfg.TransactionContext;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.deploy.ProcessDefinitionInfoCacheObject;

public class Context {
    protected static ThreadLocal<Stack<CommandContext>> commandContextThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Stack<ProcessEngineConfigurationImpl>> processEngineConfigurationStackThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Map<String, ObjectNode>> bpmnOverrideContextThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Flowable5CompatibilityHandler> flowable5CompatibilityHandlerThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Flowable5CompatibilityHandler> fallbackFlowable5CompatibilityHandlerThreadLocal = new ThreadLocal();
    protected static ResourceBundle.Control resourceBundleControl = new ResourceBundleControl();

    public static CommandContext getCommandContext() {
        Stack stack = Context.getStack(commandContextThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (CommandContext)((Object)stack.peek());
    }

    public static FlowableEngineAgenda getAgenda() {
        return Context.getCommandContext().getAgenda();
    }

    public static void setCommandContext(CommandContext commandContext) {
        Context.getStack(commandContextThreadLocal).push((Object)((Object)commandContext));
    }

    public static void removeCommandContext() {
        Context.getStack(commandContextThreadLocal).pop();
    }

    public static ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        Stack stack = Context.getStack(processEngineConfigurationStackThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (ProcessEngineConfigurationImpl)((Object)stack.peek());
    }

    public static void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        Context.getStack(processEngineConfigurationStackThreadLocal).push((Object)((Object)processEngineConfiguration));
    }

    public static void removeProcessEngineConfiguration() {
        Context.getStack(processEngineConfigurationStackThreadLocal).pop();
    }

    public static TransactionContext getTransactionContext() {
        return (TransactionContext)TransactionContextHolder.getTransactionContext();
    }

    public static void setTransactionContext(TransactionContext transactionContext) {
        TransactionContextHolder.setTransactionContext((BaseTransactionContext)transactionContext);
    }

    public static void removeTransactionContext() {
        TransactionContextHolder.removeTransactionContext();
    }

    protected static <T> Stack<T> getStack(ThreadLocal<Stack<T>> threadLocal) {
        Stack<Object> stack = threadLocal.get();
        if (stack == null) {
            stack = new Stack();
            threadLocal.set(stack);
        }
        return stack;
    }

    public static ObjectNode getBpmnOverrideElementProperties(String id, String processDefinitionId) {
        ObjectNode definitionInfoNode = Context.getProcessDefinitionInfoNode(processDefinitionId);
        ObjectNode elementProperties = null;
        if (definitionInfoNode != null) {
            elementProperties = Context.getProcessEngineConfiguration().getDynamicBpmnService().getBpmnElementProperties(id, definitionInfoNode);
        }
        return elementProperties;
    }

    public static ObjectNode getLocalizationElementProperties(String language, String id, String processDefinitionId, boolean useFallback) {
        ObjectNode definitionInfoNode = Context.getProcessDefinitionInfoNode(processDefinitionId);
        ObjectNode localizationProperties = null;
        if (definitionInfoNode != null) {
            if (!useFallback) {
                localizationProperties = Context.getProcessEngineConfiguration().getDynamicBpmnService().getLocalizationElementProperties(language, id, definitionInfoNode);
            } else {
                LinkedHashSet<Locale> candidateLocales = new LinkedHashSet<Locale>();
                candidateLocales.addAll(resourceBundleControl.getCandidateLocales(id, Locale.forLanguageTag(language)));
                for (Locale locale : candidateLocales) {
                    localizationProperties = Context.getProcessEngineConfiguration().getDynamicBpmnService().getLocalizationElementProperties(locale.toLanguageTag(), id, definitionInfoNode);
                    if (localizationProperties == null) continue;
                    break;
                }
            }
        }
        return localizationProperties;
    }

    public static void removeBpmnOverrideContext() {
        bpmnOverrideContextThreadLocal.remove();
    }

    protected static ObjectNode getProcessDefinitionInfoNode(String processDefinitionId) {
        Map<String, ObjectNode> bpmnOverrideMap = Context.getBpmnOverrideContext();
        if (!bpmnOverrideMap.containsKey(processDefinitionId)) {
            ProcessDefinitionInfoCacheObject cacheObject = Context.getProcessEngineConfiguration().getDeploymentManager().getProcessDefinitionInfoCache().get(processDefinitionId);
            Context.addBpmnOverrideElement(processDefinitionId, cacheObject.getInfoNode());
        }
        return Context.getBpmnOverrideContext().get(processDefinitionId);
    }

    protected static Map<String, ObjectNode> getBpmnOverrideContext() {
        Map<String, ObjectNode> bpmnOverrideMap = bpmnOverrideContextThreadLocal.get();
        if (bpmnOverrideMap == null) {
            bpmnOverrideMap = new HashMap<String, ObjectNode>();
        }
        return bpmnOverrideMap;
    }

    protected static void addBpmnOverrideElement(String id, ObjectNode infoNode) {
        Map<String, ObjectNode> bpmnOverrideMap = bpmnOverrideContextThreadLocal.get();
        if (bpmnOverrideMap == null) {
            bpmnOverrideMap = new HashMap<String, ObjectNode>();
            bpmnOverrideContextThreadLocal.set(bpmnOverrideMap);
        }
        bpmnOverrideMap.put(id, infoNode);
    }

    public static Flowable5CompatibilityHandler getFlowable5CompatibilityHandler() {
        return flowable5CompatibilityHandlerThreadLocal.get();
    }

    public static void setFlowable5CompatibilityHandler(Flowable5CompatibilityHandler flowable5CompatibilityHandler) {
        flowable5CompatibilityHandlerThreadLocal.set(flowable5CompatibilityHandler);
    }

    public static void removeFlowable5CompatibilityHandler() {
        flowable5CompatibilityHandlerThreadLocal.remove();
    }

    public static Flowable5CompatibilityHandler getFallbackFlowable5CompatibilityHandler() {
        return fallbackFlowable5CompatibilityHandlerThreadLocal.get();
    }

    public static void setFallbackFlowable5CompatibilityHandler(Flowable5CompatibilityHandler flowable5CompatibilityHandler) {
        fallbackFlowable5CompatibilityHandlerThreadLocal.set(flowable5CompatibilityHandler);
    }

    public static void removeFallbackFlowable5CompatibilityHandler() {
        fallbackFlowable5CompatibilityHandlerThreadLocal.remove();
    }

    public static class ResourceBundleControl
    extends ResourceBundle.Control {
        @Override
        public List<Locale> getCandidateLocales(String baseName, Locale locale) {
            return super.getCandidateLocales(baseName, locale);
        }
    }
}

