/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.jobexecutor;

import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.interceptor.CommandContextCloseListener;
import org.flowable.engine.impl.interceptor.CommandExecutor;
import org.flowable.engine.impl.jobexecutor.FailedJobCommandFactory;
import org.flowable.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailedJobListener
implements CommandContextCloseListener {
    private static final Logger log = LoggerFactory.getLogger(FailedJobListener.class);
    protected CommandExecutor commandExecutor;
    protected Job job;

    public FailedJobListener(CommandExecutor commandExecutor, Job job) {
        this.commandExecutor = commandExecutor;
        this.job = job;
    }

    @Override
    public void closing(CommandContext commandContext) {
    }

    @Override
    public void afterSessionsFlush(CommandContext commandContext) {
    }

    @Override
    public void closed(CommandContext context) {
        if (context.getEventDispatcher().isEnabled()) {
            context.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_EXECUTION_SUCCESS, this.job));
        }
    }

    @Override
    public void closeFailure(CommandContext commandContext) {
        if (commandContext.getEventDispatcher().isEnabled()) {
            commandContext.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityExceptionEvent(FlowableEngineEventType.JOB_EXECUTION_FAILURE, this.job, commandContext.getException()));
        }
        CommandConfig commandConfig = this.commandExecutor.getDefaultConfig().transactionRequiresNew();
        FailedJobCommandFactory failedJobCommandFactory = commandContext.getFailedJobCommandFactory();
        Command<Object> cmd = failedJobCommandFactory.getCommand(this.job.getId(), commandContext.getException());
        log.trace("Using FailedJobCommandFactory '{}' and command of type '{}'", failedJobCommandFactory.getClass(), cmd.getClass());
        this.commandExecutor.execute(commandConfig, cmd);
    }
}

