/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.jobexecutor;

import java.util.ArrayList;
import java.util.List;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.jobexecutor.JobHandler;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.JobEntity;
import org.flowable.engine.impl.persistence.entity.TaskEntity;

public class TriggerTimerEventJobHandler
implements JobHandler {
    public static final String TYPE = "trigger-timer";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        commandContext.getAgenda().planTriggerExecutionOperation(execution);
        if (commandContext.getEventDispatcher().isEnabled()) {
            commandContext.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.TIMER_FIRED, job));
        }
        if (execution.getCurrentFlowElement() instanceof BoundaryEvent) {
            ArrayList<String> processedElements = new ArrayList<String>();
            this.dispatchExecutionTimeOut(job, execution, processedElements, commandContext);
        }
    }

    protected void dispatchExecutionTimeOut(JobEntity timerEntity, ExecutionEntity execution, List<String> processedElements, CommandContext commandContext) {
        block8: {
            ExecutionEntity subProcessInstance;
            block7: {
                FlowElement currentElement = execution.getCurrentFlowElement();
                if (!(currentElement instanceof BoundaryEvent)) break block7;
                BoundaryEvent boundaryEvent = (BoundaryEvent)execution.getCurrentFlowElement();
                if (!boundaryEvent.isCancelActivity() || boundaryEvent.getAttachedToRef() == null || processedElements.contains(boundaryEvent.getId())) break block8;
                processedElements.add(boundaryEvent.getId());
                ExecutionEntity executionEntity = execution.getParent();
                this.dispatchExecutionTimeOut(timerEntity, executionEntity, processedElements, commandContext);
                break block8;
            }
            if (execution.getCurrentFlowElement() instanceof FlowNode) {
                Object tasks;
                processedElements.add(execution.getCurrentActivityId());
                this.dispatchActivityTimeOut(timerEntity, (FlowNode)execution.getCurrentFlowElement(), execution, commandContext);
                if (execution.getCurrentFlowElement() instanceof UserTask && !execution.isMultiInstanceRoot() && (tasks = execution.getTasks()).size() > 0) {
                    ((TaskEntity)tasks.get(0)).setCanceled(true);
                }
            }
            if (execution.getCurrentFlowElement() instanceof SubProcess) {
                for (ExecutionEntity executionEntity : execution.getExecutions()) {
                    if (processedElements.contains(executionEntity.getCurrentActivityId())) continue;
                    this.dispatchExecutionTimeOut(timerEntity, executionEntity, processedElements, commandContext);
                }
            } else if (execution.getCurrentFlowElement() instanceof CallActivity && (subProcessInstance = commandContext.getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(execution.getId())) != null) {
                List<? extends ExecutionEntity> list = subProcessInstance.getExecutions();
                for (ExecutionEntity executionEntity : list) {
                    if (processedElements.contains(executionEntity.getCurrentActivityId())) continue;
                    this.dispatchExecutionTimeOut(timerEntity, executionEntity, processedElements, commandContext);
                }
            }
        }
    }

    protected void dispatchActivityTimeOut(JobEntity timerEntity, FlowNode flowNode, ExecutionEntity execution, CommandContext commandContext) {
        commandContext.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityCancelledEvent(flowNode.getId(), flowNode.getName(), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), this.parseActivityType(flowNode), timerEntity));
    }

    protected String parseActivityType(FlowNode flowNode) {
        String elementType = flowNode.getClass().getSimpleName();
        elementType = elementType.substring(0, 1).toLowerCase() + elementType.substring(1);
        return elementType;
    }
}

