/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import java.util.List;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.form.DefaultStartFormHandler;
import org.flowable.engine.impl.form.DefaultTaskFormHandler;
import org.flowable.engine.impl.form.StartFormHandler;
import org.flowable.engine.impl.form.TaskFormHandler;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.ProcessDefinition;

public class FormHandlerUtil {
    public static StartFormHandler getStartFormHandler(CommandContext commandContext, ProcessDefinition processDefinition) {
        DefaultStartFormHandler startFormHandler = new DefaultStartFormHandler();
        Process process = ProcessDefinitionUtil.getProcess(processDefinition.getId());
        FlowElement initialFlowElement = process.getInitialFlowElement();
        if (initialFlowElement instanceof StartEvent) {
            StartEvent startEvent = (StartEvent)initialFlowElement;
            List formProperties = startEvent.getFormProperties();
            String formKey = startEvent.getFormKey();
            DeploymentEntity deploymentEntity = (DeploymentEntity)commandContext.getDeploymentEntityManager().findById(processDefinition.getDeploymentId());
            startFormHandler.parseConfiguration(formProperties, formKey, deploymentEntity, processDefinition);
            return startFormHandler;
        }
        return null;
    }

    public static TaskFormHandler getTaskFormHandlder(String processDefinitionId, String taskId) {
        Process process = ProcessDefinitionUtil.getProcess(processDefinitionId);
        FlowElement flowElement = process.getFlowElement(taskId, true);
        if (flowElement instanceof UserTask) {
            UserTask userTask = (UserTask)flowElement;
            ProcessDefinition processDefinitionEntity = ProcessDefinitionUtil.getProcessDefinition(processDefinitionId);
            DeploymentEntity deploymentEntity = (DeploymentEntity)Context.getProcessEngineConfiguration().getDeploymentEntityManager().findById(processDefinitionEntity.getDeploymentId());
            DefaultTaskFormHandler taskFormHandler = new DefaultTaskFormHandler();
            taskFormHandler.parseConfiguration(userTask.getFormProperties(), userTask.getFormKey(), deploymentEntity, processDefinitionEntity);
            return taskFormHandler;
        }
        return null;
    }

    public static TaskFormHandler getTaskFormHandlder(TaskEntity taskEntity) {
        if (taskEntity.getProcessDefinitionId() != null) {
            return FormHandlerUtil.getTaskFormHandlder(taskEntity.getProcessDefinitionId(), taskEntity.getTaskDefinitionKey());
        }
        return null;
    }
}

