/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.delegate.event.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEventListener;
import org.flowable.engine.common.api.delegate.event.FlowableEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowableEventSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FlowableEventSupport.class);
    protected List<FlowableEventListener> eventListeners = new CopyOnWriteArrayList<FlowableEventListener>();
    protected Map<FlowableEventType, List<FlowableEventListener>> typedListeners = new HashMap<FlowableEventType, List<FlowableEventListener>>();

    public synchronized void addEventListener(FlowableEventListener listenerToAdd) {
        if (listenerToAdd == null) {
            throw new FlowableIllegalArgumentException("Listener cannot be null.");
        }
        if (!this.eventListeners.contains(listenerToAdd)) {
            this.eventListeners.add(listenerToAdd);
        }
    }

    public synchronized void addEventListener(FlowableEventListener listenerToAdd, FlowableEventType ... types) {
        if (listenerToAdd == null) {
            throw new FlowableIllegalArgumentException("Listener cannot be null.");
        }
        if (types == null || types.length == 0) {
            this.addEventListener(listenerToAdd);
        } else {
            for (FlowableEventType type : types) {
                this.addTypedEventListener(listenerToAdd, type);
            }
        }
    }

    public void removeEventListener(FlowableEventListener listenerToRemove) {
        this.eventListeners.remove(listenerToRemove);
        for (List<FlowableEventListener> listeners : this.typedListeners.values()) {
            listeners.remove(listenerToRemove);
        }
    }

    public void dispatchEvent(FlowableEvent event) {
        List<FlowableEventListener> typed;
        if (event == null) {
            throw new FlowableIllegalArgumentException("Event cannot be null.");
        }
        if (event.getType() == null) {
            throw new FlowableIllegalArgumentException("Event type cannot be null.");
        }
        if (!this.eventListeners.isEmpty()) {
            for (FlowableEventListener listener : this.eventListeners) {
                this.dispatchEvent(event, listener);
            }
        }
        if ((typed = this.typedListeners.get(event.getType())) != null && !typed.isEmpty()) {
            for (FlowableEventListener listener : typed) {
                this.dispatchEvent(event, listener);
            }
        }
    }

    protected void dispatchEvent(FlowableEvent event, FlowableEventListener listener) {
        try {
            listener.onEvent(event);
        }
        catch (Throwable t) {
            if (listener.isFailOnException()) {
                throw new FlowableException("Exception while executing event-listener", t);
            }
            LOG.warn("Exception while executing event-listener, which was ignored", t);
        }
    }

    protected synchronized void addTypedEventListener(FlowableEventListener listener, FlowableEventType type) {
        List<FlowableEventListener> listeners = this.typedListeners.get(type);
        if (listeners == null) {
            listeners = new CopyOnWriteArrayList<FlowableEventListener>();
            this.typedListeners.put(type, listeners);
        }
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }
}

