/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.agenda;

import java.util.Collection;
import java.util.List;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.HasExecutionListeners;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.impl.util.CollectionUtil;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.JobEntity;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.logging.LogMDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinueProcessOperation
extends AbstractOperation {
    private static Logger logger = LoggerFactory.getLogger(ContinueProcessOperation.class);
    protected boolean forceSynchronousOperation;
    protected boolean inCompensation;

    public ContinueProcessOperation(CommandContext commandContext, ExecutionEntity execution, boolean forceSynchronousOperation, boolean inCompensation) {
        super(commandContext, execution);
        this.forceSynchronousOperation = forceSynchronousOperation;
        this.inCompensation = inCompensation;
    }

    public ContinueProcessOperation(CommandContext commandContext, ExecutionEntity execution) {
        this(commandContext, execution, false, false);
    }

    @Override
    public void run() {
        FlowElement currentFlowElement = this.getCurrentFlowElement(this.execution);
        if (currentFlowElement instanceof FlowNode) {
            this.continueThroughFlowNode((FlowNode)currentFlowElement);
        } else if (currentFlowElement instanceof SequenceFlow) {
            this.continueThroughSequenceFlow((SequenceFlow)currentFlowElement);
        } else {
            throw new FlowableException("Programmatic error: no current flow element found or invalid type: " + currentFlowElement + ". Halting.");
        }
    }

    protected void executeProcessStartExecutionListeners() {
        Process process = ProcessDefinitionUtil.getProcess(this.execution.getProcessDefinitionId());
        this.executeExecutionListeners((HasExecutionListeners)process, this.execution.getParent(), "start");
    }

    protected void continueThroughFlowNode(FlowNode flowNode) {
        this.execution.setActive(true);
        if (flowNode.getIncomingFlows() != null && flowNode.getIncomingFlows().size() == 0 && flowNode.getSubProcess() == null) {
            this.executeProcessStartExecutionListeners();
        }
        if (flowNode instanceof SubProcess) {
            this.createChildExecutionForSubProcess((SubProcess)flowNode);
        }
        if (flowNode instanceof Activity && ((Activity)flowNode).hasMultiInstanceLoopCharacteristics()) {
            this.executeMultiInstanceSynchronous(flowNode);
        } else if (this.forceSynchronousOperation || !flowNode.isAsynchronous()) {
            this.executeSynchronous(flowNode);
        } else {
            this.executeAsynchronous(flowNode);
        }
    }

    protected void createChildExecutionForSubProcess(SubProcess subProcess) {
        ExecutionEntity parentScopeExecution = this.findFirstParentScopeExecution(this.execution);
        ExecutionEntity subProcessExecution = this.commandContext.getExecutionEntityManager().createChildExecution(parentScopeExecution);
        subProcessExecution.setCurrentFlowElement((FlowElement)subProcess);
        subProcessExecution.setScope(true);
        this.commandContext.getExecutionEntityManager().deleteRelatedDataForExecution(this.execution, null, false);
        this.commandContext.getExecutionEntityManager().delete(this.execution);
        this.execution = subProcessExecution;
    }

    protected void executeSynchronous(FlowNode flowNode) {
        ActivityBehavior activityBehavior;
        List boundaryEvents;
        this.commandContext.getHistoryManager().recordActivityStart(this.execution);
        if (CollectionUtil.isNotEmpty((Collection)flowNode.getExecutionListeners())) {
            this.executeExecutionListeners((HasExecutionListeners)flowNode, "start");
        }
        if (!this.inCompensation && flowNode instanceof Activity && CollectionUtil.isNotEmpty((Collection)(boundaryEvents = ((Activity)flowNode).getBoundaryEvents()))) {
            this.executeBoundaryEvents(boundaryEvents, this.execution);
        }
        if ((activityBehavior = (ActivityBehavior)flowNode.getBehavior()) != null) {
            this.executeActivityBehavior(activityBehavior, flowNode);
        } else {
            logger.debug("No activityBehavior on activity '{}' with execution {}", (Object)flowNode.getId(), (Object)this.execution.getId());
            Context.getAgenda().planTakeOutgoingSequenceFlowsOperation(this.execution, true);
        }
    }

    protected void executeAsynchronous(FlowNode flowNode) {
        JobEntity job = this.commandContext.getJobManager().createAsyncJob(this.execution, flowNode.isExclusive());
        this.commandContext.getJobManager().scheduleAsyncJob(job);
    }

    protected void executeMultiInstanceSynchronous(FlowNode flowNode) {
        ActivityBehavior activityBehavior;
        List boundaryEvents;
        if (CollectionUtil.isNotEmpty((Collection)flowNode.getExecutionListeners())) {
            this.executeExecutionListeners((HasExecutionListeners)flowNode, "start");
        }
        if (!this.hasMultiInstanceRootExecution(this.execution, flowNode)) {
            this.execution = this.createMultiInstanceRootExecution(this.execution);
        }
        if (!this.inCompensation && flowNode instanceof Activity && CollectionUtil.isNotEmpty((Collection)(boundaryEvents = ((Activity)flowNode).getBoundaryEvents()))) {
            this.executeBoundaryEvents(boundaryEvents, this.execution);
        }
        if ((activityBehavior = (ActivityBehavior)flowNode.getBehavior()) == null) {
            throw new FlowableException("Expected an activity behavior in flow node " + flowNode.getId());
        }
        this.executeActivityBehavior(activityBehavior, flowNode);
    }

    protected boolean hasMultiInstanceRootExecution(ExecutionEntity execution, FlowNode flowNode) {
        for (ExecutionEntity currentExecution = execution.getParent(); currentExecution != null; currentExecution = currentExecution.getParent()) {
            if (!currentExecution.isMultiInstanceRoot() || !flowNode.getId().equals(currentExecution.getActivityId())) continue;
            return true;
        }
        return false;
    }

    protected ExecutionEntity createMultiInstanceRootExecution(ExecutionEntity execution) {
        ExecutionEntity parentExecution = execution.getParent();
        FlowElement flowElement = execution.getCurrentFlowElement();
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        executionEntityManager.deleteRelatedDataForExecution(execution, null, false);
        executionEntityManager.delete(execution);
        ExecutionEntity multiInstanceRootExecution = executionEntityManager.createChildExecution(parentExecution);
        multiInstanceRootExecution.setCurrentFlowElement(flowElement);
        multiInstanceRootExecution.setMultiInstanceRoot(true);
        multiInstanceRootExecution.setActive(false);
        return multiInstanceRootExecution;
    }

    protected void executeActivityBehavior(ActivityBehavior activityBehavior, FlowNode flowNode) {
        logger.debug("Executing activityBehavior {} on activity '{}' with execution {}", new Object[]{activityBehavior.getClass(), flowNode.getId(), this.execution.getId()});
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityEvent(FlowableEngineEventType.ACTIVITY_STARTED, flowNode.getId(), flowNode.getName(), this.execution.getId(), this.execution.getProcessInstanceId(), this.execution.getProcessDefinitionId(), (FlowElement)flowNode));
        }
        try {
            activityBehavior.execute(this.execution);
        }
        catch (RuntimeException e) {
            if (LogMDC.isMDCEnabled()) {
                LogMDC.putMDCExecution(this.execution);
            }
            throw e;
        }
    }

    protected void continueThroughSequenceFlow(SequenceFlow sequenceFlow) {
        if (CollectionUtil.isNotEmpty((Collection)sequenceFlow.getExecutionListeners())) {
            this.executeExecutionListeners((HasExecutionListeners)sequenceFlow, "start");
            this.executeExecutionListeners((HasExecutionListeners)sequenceFlow, "take");
            this.executeExecutionListeners((HasExecutionListeners)sequenceFlow, "end");
        }
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            FlowElement sourceFlowElement = sequenceFlow.getSourceFlowElement();
            FlowElement targetFlowElement = sequenceFlow.getTargetFlowElement();
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createSequenceFlowTakenEvent(this.execution, FlowableEngineEventType.SEQUENCEFLOW_TAKEN, sequenceFlow.getId(), sourceFlowElement != null ? sourceFlowElement.getId() : null, sourceFlowElement != null ? sourceFlowElement.getName() : null, sourceFlowElement != null ? sourceFlowElement.getClass().getName() : null, sourceFlowElement != null ? ((FlowNode)sourceFlowElement).getBehavior() : null, targetFlowElement != null ? targetFlowElement.getId() : null, targetFlowElement != null ? targetFlowElement.getName() : null, targetFlowElement != null ? targetFlowElement.getClass().getName() : null, targetFlowElement != null ? ((FlowNode)targetFlowElement).getBehavior() : null));
        }
        FlowElement targetFlowElement = sequenceFlow.getTargetFlowElement();
        this.execution.setCurrentFlowElement(targetFlowElement);
        logger.debug("Sequence flow '{}' encountered. Continuing process by following it using execution {}", (Object)sequenceFlow.getId(), (Object)this.execution.getId());
        this.execution.setActive(false);
        if (targetFlowElement instanceof FlowNode) {
            this.continueThroughFlowNode((FlowNode)targetFlowElement);
        } else {
            this.agenda.planContinueProcessOperation(this.execution);
        }
    }

    protected void executeBoundaryEvents(Collection<BoundaryEvent> boundaryEvents, ExecutionEntity execution) {
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            if (CollectionUtil.isEmpty((Collection)boundaryEvent.getEventDefinitions()) || boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition) continue;
            ExecutionEntity childExecutionEntity = this.commandContext.getExecutionEntityManager().createChildExecution(execution);
            childExecutionEntity.setParentId(execution.getId());
            childExecutionEntity.setCurrentFlowElement((FlowElement)boundaryEvent);
            childExecutionEntity.setScope(false);
            ActivityBehavior boundaryEventBehavior = (ActivityBehavior)boundaryEvent.getBehavior();
            logger.debug("Executing boundary event activityBehavior {} with execution {}", boundaryEventBehavior.getClass(), (Object)childExecutionEntity.getId());
            boundaryEventBehavior.execute(childExecutionEntity);
        }
    }
}

