/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.asyncexecutor;

import java.util.Collection;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.JobInfoEntity;
import org.flowable.engine.impl.persistence.entity.JobInfoEntityManager;
import org.flowable.engine.runtime.Job;

public class ResetExpiredJobsCmd
implements Command<Void> {
    protected Collection<String> jobIds;
    protected JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager;

    public ResetExpiredJobsCmd(Collection<String> jobsIds, JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager) {
        this.jobIds = jobsIds;
        this.jobEntityManager = jobEntityManager;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        boolean messageQueueMode = commandContext.getProcessEngineConfiguration().isAsyncExecutorIsMessageQueueMode();
        for (String jobId : this.jobIds) {
            if (!messageQueueMode) {
                Job job = (Job)commandContext.getJobEntityManager().findById(jobId);
                commandContext.getJobManager().unacquire(job);
                continue;
            }
            this.jobEntityManager.resetExpiredJob(jobId);
        }
        return null;
    }
}

