/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.asyncexecutor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.flowable.engine.common.api.FlowableOptimisticLockingException;
import org.flowable.engine.impl.asyncexecutor.AsyncExecutor;
import org.flowable.engine.impl.asyncexecutor.FindExpiredJobsCmd;
import org.flowable.engine.impl.asyncexecutor.ResetExpiredJobsCmd;
import org.flowable.engine.impl.persistence.entity.JobInfoEntity;
import org.flowable.engine.impl.persistence.entity.JobInfoEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResetExpiredJobsRunnable
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(ResetExpiredJobsRunnable.class);
    protected final String name;
    protected final AsyncExecutor asyncExecutor;
    protected final JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager;
    protected volatile boolean isInterrupted;
    protected final Object MONITOR = new Object();
    protected final AtomicBoolean isWaiting = new AtomicBoolean(false);

    public ResetExpiredJobsRunnable(String name, AsyncExecutor asyncExecutor, JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager) {
        this.name = name;
        this.asyncExecutor = asyncExecutor;
        this.jobEntityManager = jobEntityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        log.info("starting to reset expired jobs");
        Thread.currentThread().setName(this.name);
        while (!this.isInterrupted) {
            try {
                List<? extends JobInfoEntity> expiredJobs = this.asyncExecutor.getProcessEngineConfiguration().getCommandExecutor().execute(new FindExpiredJobsCmd(this.asyncExecutor.getResetExpiredJobsPageSize(), this.jobEntityManager));
                ArrayList<String> expiredJobIds = new ArrayList<String>(expiredJobs.size());
                for (JobInfoEntity jobInfoEntity : expiredJobs) {
                    expiredJobIds.add(jobInfoEntity.getId());
                }
                if (expiredJobIds.size() > 0) {
                    this.asyncExecutor.getProcessEngineConfiguration().getCommandExecutor().execute(new ResetExpiredJobsCmd(expiredJobIds, this.jobEntityManager));
                }
            }
            catch (Throwable e) {
                if (e instanceof FlowableOptimisticLockingException) {
                    log.debug("Optimistic lock exception while resetting locked jobs", e);
                }
                log.error("exception during resetting expired jobs: {}", (Object)e.getMessage(), (Object)e);
            }
            try {
                Object e = this.MONITOR;
                synchronized (e) {
                    if (!this.isInterrupted) {
                        this.isWaiting.set(true);
                        this.MONITOR.wait(this.asyncExecutor.getResetExpiredJobsInterval());
                    }
                }
            }
            catch (InterruptedException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("async reset expired jobs wait interrupted");
            }
            finally {
                this.isWaiting.set(false);
            }
        }
        log.info("stopped resetting expired jobs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.MONITOR;
        synchronized (object) {
            this.isInterrupted = true;
            if (this.isWaiting.compareAndSet(true, false)) {
                this.MONITOR.notifyAll();
            }
        }
    }
}

