/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.List;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.util.CollectionUtil;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;

public class BoundaryEventActivityBehavior
extends FlowNodeActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected boolean interrupting;

    public BoundaryEventActivityBehavior() {
    }

    public BoundaryEventActivityBehavior(boolean interrupting) {
        this.interrupting = interrupting;
    }

    @Override
    public void execute(DelegateExecution execution) {
    }

    @Override
    public void trigger(DelegateExecution execution, String triggerName, Object triggerData) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        CommandContext commandContext = Context.getCommandContext();
        if (this.interrupting) {
            this.executeInterruptingBehavior(executionEntity, commandContext);
        } else {
            this.executeNonInterruptingBehavior(executionEntity, commandContext);
        }
    }

    protected void executeInterruptingBehavior(ExecutionEntity executionEntity, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        ExecutionEntity attachedRefScopeExecution = (ExecutionEntity)executionEntityManager.findById(executionEntity.getParentId());
        ExecutionEntity parentScopeExecution = null;
        ExecutionEntity currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(attachedRefScopeExecution.getParentId());
        while (currentlyExaminedExecution != null && parentScopeExecution == null) {
            if (currentlyExaminedExecution.isScope()) {
                parentScopeExecution = currentlyExaminedExecution;
                continue;
            }
            currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(currentlyExaminedExecution.getParentId());
        }
        if (parentScopeExecution == null) {
            throw new FlowableException("Programmatic error: no parent scope execution found for boundary event");
        }
        this.deleteChildExecutions(attachedRefScopeExecution, executionEntity, commandContext);
        executionEntity.setParent(parentScopeExecution);
        if (executionEntity.getCurrentFlowElement() instanceof FlowNode && ((FlowNode)executionEntity.getCurrentFlowElement()).getOutgoingFlows().isEmpty()) {
            commandContext.getHistoryManager().recordActivityEnd(executionEntity, null);
        }
        commandContext.getAgenda().planTakeOutgoingSequenceFlowsOperation(executionEntity, true);
    }

    protected void executeNonInterruptingBehavior(ExecutionEntity executionEntity, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        ExecutionEntity parentExecutionEntity = (ExecutionEntity)executionEntityManager.findById(executionEntity.getParentId());
        ExecutionEntity scopeExecution = null;
        ExecutionEntity currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(parentExecutionEntity.getParentId());
        while (currentlyExaminedExecution != null && scopeExecution == null) {
            if (currentlyExaminedExecution.isScope()) {
                scopeExecution = currentlyExaminedExecution;
                continue;
            }
            currentlyExaminedExecution = (ExecutionEntity)executionEntityManager.findById(currentlyExaminedExecution.getParentId());
        }
        if (scopeExecution == null) {
            throw new FlowableException("Programmatic error: no parent scope execution found for boundary event");
        }
        commandContext.getHistoryManager().recordActivityEnd(executionEntity, null);
        ExecutionEntity nonInterruptingExecution = executionEntityManager.createChildExecution(scopeExecution);
        nonInterruptingExecution.setActive(false);
        nonInterruptingExecution.setCurrentFlowElement(executionEntity.getCurrentFlowElement());
        commandContext.getAgenda().planTakeOutgoingSequenceFlowsOperation(nonInterruptingExecution, true);
    }

    protected void deleteChildExecutions(ExecutionEntity parentExecution, ExecutionEntity notToDeleteExecution, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        List<ExecutionEntity> childExecutions = executionEntityManager.findChildExecutionsByParentExecutionId(parentExecution.getId());
        if (CollectionUtil.isNotEmpty(childExecutions)) {
            for (ExecutionEntity childExecution : childExecutions) {
                if (childExecution.getId().equals(notToDeleteExecution.getId())) continue;
                this.deleteChildExecutions(childExecution, notToDeleteExecution, commandContext);
            }
        }
        String deleteReason = "boundary event (" + notToDeleteExecution.getCurrentActivityId() + ")";
        ExecutionEntity subProcessExecution = executionEntityManager.findSubProcessInstanceBySuperExecutionId(parentExecution.getId());
        if (subProcessExecution != null) {
            executionEntityManager.deleteProcessInstanceExecutionEntity(subProcessExecution.getId(), subProcessExecution.getCurrentActivityId(), deleteReason, true, true, true);
        }
        executionEntityManager.deleteExecutionAndRelatedData(parentExecution, deleteReason, false);
    }

    public boolean isInterrupting() {
        return this.interrupting;
    }

    public void setInterrupting(boolean interrupting) {
        this.interrupting = interrupting;
    }
}

