/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.listener;

import org.flowable.engine.delegate.DelegateTask;
import org.flowable.engine.delegate.Expression;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.scripting.ScriptingEngines;

public class ScriptTaskListener
implements TaskListener {
    private static final long serialVersionUID = -8915149072830499057L;
    protected Expression script;
    protected Expression language;
    protected Expression resultVariable;
    protected boolean autoStoreVariables;

    @Override
    public void notify(DelegateTask delegateTask) {
        this.validateParameters();
        ScriptingEngines scriptingEngines = Context.getProcessEngineConfiguration().getScriptingEngines();
        Object result = scriptingEngines.evaluate(this.script.getExpressionText(), this.language.getExpressionText(), delegateTask, this.autoStoreVariables);
        if (this.resultVariable != null) {
            delegateTask.setVariable(this.resultVariable.getExpressionText(), result);
        }
    }

    protected void validateParameters() {
        if (this.script == null) {
            throw new IllegalArgumentException("The field 'script' should be set on the TaskListener");
        }
        if (this.language == null) {
            throw new IllegalArgumentException("The field 'language' should be set on the TaskListener");
        }
    }

    public void setScript(Expression script) {
        this.script = script;
    }

    public void setLanguage(Expression language) {
        this.language = language;
    }

    public void setResultVariable(Expression resultVariable) {
        this.resultVariable = resultVariable;
    }

    public void setAutoStoreVariables(boolean autoStoreVariables) {
        this.autoStoreVariables = autoStoreVariables;
    }
}

