/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.HistoryJobEntity;
import org.flowable.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteHistoryJobCmd
implements Command<Object>,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(DeleteHistoryJobCmd.class);
    private static final long serialVersionUID = 1L;
    protected String historyJobId;

    public DeleteHistoryJobCmd(String historyJobId) {
        this.historyJobId = historyJobId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        HistoryJobEntity jobToDelete = this.getJobToDelete(commandContext);
        this.sendCancelEvent(jobToDelete);
        commandContext.getHistoryJobEntityManager().delete(jobToDelete);
        return null;
    }

    protected void sendCancelEvent(HistoryJobEntity jobToDelete) {
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_CANCELED, jobToDelete));
        }
    }

    protected HistoryJobEntity getJobToDelete(CommandContext commandContext) {
        HistoryJobEntity job;
        if (this.historyJobId == null) {
            throw new FlowableIllegalArgumentException("jobId is null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Deleting job {}", (Object)this.historyJobId);
        }
        if ((job = (HistoryJobEntity)commandContext.getHistoryJobEntityManager().findById(this.historyJobId)) == null) {
            throw new FlowableObjectNotFoundException("No history job found with id '" + this.historyJobId + "'", Job.class);
        }
        return job;
    }
}

