/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;

public abstract class NeedsActiveProcessDefinitionCmd<T>
implements Command<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public NeedsActiveProcessDefinitionCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public T execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = ProcessDefinitionUtil.getProcessDefinitionFromDatabase(this.processDefinitionId);
        if (processDefinition.isSuspended()) {
            throw new FlowableException("Cannot execute operation because process definition '" + processDefinition.getName() + "' (id=" + processDefinition.getId() + ") is suspended");
        }
        return this.execute(commandContext, processDefinition);
    }

    protected abstract T execute(CommandContext var1, ProcessDefinitionEntity var2);
}

