/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.List;
import org.flowable.engine.impl.HistoryJobQueryImpl;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.runtime.HistoryJob;

public class UnacquireOwnedHistoryJobsCmd
implements Command<Void> {
    private final String lockOwner;
    private final String tenantId;

    public UnacquireOwnedHistoryJobsCmd(String lockOwner, String tenantId) {
        this.lockOwner = lockOwner;
        this.tenantId = tenantId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        HistoryJobQueryImpl jobQuery = new HistoryJobQueryImpl(commandContext);
        jobQuery.lockOwner(this.lockOwner);
        jobQuery.jobTenantId(this.tenantId);
        List<HistoryJob> jobs = commandContext.getHistoryJobEntityManager().findHistoryJobsByQueryCriteria(jobQuery);
        for (HistoryJob job : jobs) {
            commandContext.getJobManager().unacquire(job);
        }
        return null;
    }
}

