/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.PropertyEntity;
import org.flowable.engine.impl.persistence.entity.PropertyEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateTaskRelatedEntityCountCfgCmd
implements Command<Void> {
    private static final Logger logger = LoggerFactory.getLogger(ValidateTaskRelatedEntityCountCfgCmd.class);
    public static String PROPERTY_TASK_RELATED_ENTITY_COUNT = "cfg.task-related-entities-count";

    @Override
    public Void execute(CommandContext commandContext) {
        PropertyEntityManager propertyEntityManager = commandContext.getPropertyEntityManager();
        boolean configProperty = commandContext.getProcessEngineConfiguration().getPerformanceSettings().isEnableTaskRelationshipCounts();
        PropertyEntity propertyEntity = (PropertyEntity)propertyEntityManager.findById(PROPERTY_TASK_RELATED_ENTITY_COUNT);
        if (propertyEntity == null) {
            PropertyEntity newPropertyEntity = (PropertyEntity)propertyEntityManager.create();
            newPropertyEntity.setName(PROPERTY_TASK_RELATED_ENTITY_COUNT);
            newPropertyEntity.setValue(Boolean.toString(configProperty));
            propertyEntityManager.insert(newPropertyEntity);
        } else {
            boolean propertyValue = Boolean.valueOf(propertyEntity.getValue().toLowerCase());
            if (!configProperty && propertyValue) {
                if (logger.isInfoEnabled()) {
                    logger.info("Configuration change: task related entity counting feature was enabled before, but now disabled. Updating all task entities.");
                }
                commandContext.getProcessEngineConfiguration().getTaskDataManager().updateAllTaskRelatedEntityCountFlags(configProperty);
            }
            if (configProperty != propertyValue) {
                propertyEntity.setValue(Boolean.toString(configProperty));
                propertyEntityManager.update(propertyEntity);
            }
        }
        return null;
    }
}

