/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.AbstractHistoryManager;
import org.flowable.engine.impl.history.HistoryLevel;
import org.flowable.engine.impl.history.async.AsyncHistoryDateUtil;
import org.flowable.engine.impl.history.async.AsyncHistorySession;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.engine.repository.ProcessDefinition;

public class AsyncHistoryManager
extends AbstractHistoryManager {
    public AsyncHistoryManager(ProcessEngineConfigurationImpl processEngineConfiguration, HistoryLevel historyLevel) {
        super(processEngineConfiguration, historyLevel);
    }

    public AsyncHistorySession getAsyncHistorySession() {
        return this.getSession(AsyncHistorySession.class);
    }

    @Override
    public boolean isHistoryLevelAtLeast(HistoryLevel level) {
        return this.processEngineConfiguration.getHistoryLevel().isAtLeast(level);
    }

    @Override
    public boolean isHistoryEnabled() {
        return this.processEngineConfiguration.getHistoryLevel() != HistoryLevel.NONE;
    }

    @Override
    public void recordProcessInstanceStart(ExecutionEntity processInstance) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "id", processInstance.getId());
            this.putIfNotNull(data, "processInstanceId", processInstance.getProcessInstanceId());
            this.putIfNotNull(data, "name", processInstance.getName());
            this.putIfNotNull(data, "businessKey", processInstance.getBusinessKey());
            this.putIfNotNull(data, "processDefinitionId", processInstance.getProcessDefinitionId());
            this.putIfNotNull(data, "processDefinitionKey", processInstance.getProcessDefinitionKey());
            this.putIfNotNull(data, "processDefinitionName", processInstance.getProcessDefinitionName());
            this.putIfNotNull(data, "processDefinitionVersion", processInstance.getProcessDefinitionVersion() != null ? Integer.toString(processInstance.getProcessDefinitionVersion()) : null);
            this.putIfNotNull(data, "deploymentId", processInstance.getDeploymentId());
            this.putIfNotNull(data, "startTime", processInstance.getStartTime());
            this.putIfNotNull(data, "startUserId", processInstance.getStartUserId());
            this.putIfNotNull(data, "startActivityId", processInstance.getStartActivityId());
            this.putIfNotNull(data, "superProcessInstanceId", processInstance.getSuperExecution() != null ? processInstance.getSuperExecution().getProcessInstanceId() : null);
            this.putIfNotNull(data, "tenantId", processInstance.getTenantId());
            this.getAsyncHistorySession().addHistoricData("process-instance-start", data, processInstance.getTenantId());
        }
    }

    @Override
    public void recordProcessInstanceEnd(ExecutionEntity processInstance, String deleteReason, String activityId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "id", processInstance.getId());
            this.putIfNotNull(data, "processInstanceId", processInstance.getProcessInstanceId());
            this.putIfNotNull(data, "name", processInstance.getName());
            this.putIfNotNull(data, "businessKey", processInstance.getBusinessKey());
            this.putIfNotNull(data, "processDefinitionId", processInstance.getProcessDefinitionId());
            ProcessDefinition processDefinition = this.processEngineConfiguration.getDeploymentManager().findDeployedProcessDefinitionById(processInstance.getProcessDefinitionId());
            this.putIfNotNull(data, "processDefinitionKey", processDefinition.getKey());
            this.putIfNotNull(data, "processDefinitionName", processDefinition.getName());
            this.putIfNotNull(data, "processDefinitionVersion", processDefinition.getVersion());
            this.putIfNotNull(data, "deploymentId", processInstance.getDeploymentId());
            this.putIfNotNull(data, "startTime", processInstance.getStartTime());
            this.putIfNotNull(data, "startUserId", processInstance.getStartUserId());
            this.putIfNotNull(data, "startActivityId", processInstance.getStartActivityId());
            this.putIfNotNull(data, "superProcessInstanceId", processInstance.getSuperExecution() != null ? processInstance.getSuperExecution().getProcessInstanceId() : null);
            this.putIfNotNull(data, "tenantId", processInstance.getTenantId());
            this.putIfNotNull(data, "deleteReason", deleteReason);
            this.putIfNotNull(data, "endTime", this.getClock().getCurrentTime());
            this.putIfNotNull(data, "activityId", activityId);
            this.getAsyncHistorySession().addHistoricData("process-instance-end", data);
        }
    }

    @Override
    public void recordProcessInstanceNameChange(String processInstanceId, String newName) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "processInstanceId", processInstanceId);
            this.putIfNotNull(data, "name", newName);
            this.putIfNotNull(data, "property", "name");
            this.getAsyncHistorySession().addHistoricData("process-instance-property-changed", data);
        }
    }

    @Override
    public void recordSubProcessInstanceStart(ExecutionEntity parentExecution, ExecutionEntity subProcessInstance) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "id", subProcessInstance.getId());
            this.putIfNotNull(data, "processInstanceId", subProcessInstance.getProcessInstanceId());
            this.putIfNotNull(data, "businessKey", subProcessInstance.getBusinessKey());
            this.putIfNotNull(data, "processDefinitionId", subProcessInstance.getProcessDefinitionId());
            this.putIfNotNull(data, "processDefinitionKey", subProcessInstance.getProcessDefinitionKey());
            this.putIfNotNull(data, "processDefinitionName", subProcessInstance.getProcessDefinitionName());
            this.putIfNotNull(data, "processDefinitionVersion", subProcessInstance.getProcessDefinitionVersion() != null ? Integer.toString(subProcessInstance.getProcessDefinitionVersion()) : null);
            this.putIfNotNull(data, "deploymentId", subProcessInstance.getDeploymentId());
            this.putIfNotNull(data, "startTime", subProcessInstance.getStartTime());
            this.putIfNotNull(data, "startUserId", subProcessInstance.getStartUserId());
            this.putIfNotNull(data, "startActivityId", subProcessInstance.getStartActivityId());
            this.putIfNotNull(data, "superProcessInstanceId", subProcessInstance.getSuperExecution() != null ? subProcessInstance.getSuperExecution().getProcessInstanceId() : null);
            this.putIfNotNull(data, "tenantId", subProcessInstance.getTenantId());
            this.putIfNotNull(data, "executionId", parentExecution.getId());
            String activityId = this.getActivityIdForExecution(parentExecution);
            this.putIfNotNull(data, "activityId", activityId);
            this.getAsyncHistorySession().addHistoricData("subprocess-instance-start", data, subProcessInstance.getTenantId());
        }
    }

    @Override
    public void recordProcessInstanceDeleted(String processInstanceId) {
        if (this.isHistoryEnabled()) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "processInstanceId", processInstanceId);
            this.getAsyncHistorySession().addHistoricData("process-instance-deleted", data);
        }
    }

    @Override
    public void recordDeleteHistoricProcessInstancesByProcessDefinitionId(String processDefinitionId) {
        if (this.isHistoryEnabled()) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "processDefinitionId", processDefinitionId);
            this.getAsyncHistorySession().addHistoricData("process-instance-deleted-by-process-definition-id", data);
        }
    }

    @Override
    public void recordActivityStart(ExecutionEntity executionEntity) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && executionEntity.getActivityId() != null && executionEntity.getCurrentFlowElement() != null) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "processDefinitionId", executionEntity.getProcessDefinitionId());
            this.putIfNotNull(data, "processInstanceId", executionEntity.getProcessInstanceId());
            this.putIfNotNull(data, "executionId", executionEntity.getId());
            this.putIfNotNull(data, "activityId", executionEntity.getActivityId());
            this.putIfNotNull(data, "startTime", this.getClock().getCurrentTime());
            if (executionEntity.getCurrentFlowElement() != null) {
                this.putIfNotNull(data, "activityName", executionEntity.getCurrentFlowElement().getName());
                this.putIfNotNull(data, "activityType", this.parseActivityType(executionEntity.getCurrentFlowElement()));
            }
            if (executionEntity.getTenantId() != null) {
                this.putIfNotNull(data, "tenantId", executionEntity.getTenantId());
            }
            this.getAsyncHistorySession().addHistoricData("activity-start", data, executionEntity.getTenantId());
        }
    }

    @Override
    public void recordActivityEnd(ExecutionEntity executionEntity, String deleteReason) {
        String activityId;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && StringUtils.isNotEmpty((CharSequence)(activityId = this.getActivityIdForExecution(executionEntity)))) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "processDefinitionId", executionEntity.getProcessDefinitionId());
            this.putIfNotNull(data, "processInstanceId", executionEntity.getProcessInstanceId());
            this.putIfNotNull(data, "executionId", executionEntity.getId());
            this.putIfNotNull(data, "activityId", activityId);
            if (executionEntity.getCurrentFlowElement() != null) {
                this.putIfNotNull(data, "activityName", executionEntity.getCurrentFlowElement().getName());
                this.putIfNotNull(data, "activityType", this.parseActivityType(executionEntity.getCurrentFlowElement()));
            }
            if (executionEntity.getTenantId() != null) {
                this.putIfNotNull(data, "tenantId", executionEntity.getTenantId());
            }
            this.putIfNotNull(data, "deleteReason", deleteReason);
            this.putIfNotNull(data, "endTime", this.getClock().getCurrentTime());
            Map<String, String> correspondingActivityStartData = this.getActivityStart(executionEntity.getId(), activityId, true);
            if (correspondingActivityStartData == null) {
                this.getAsyncHistorySession().addHistoricData("activity-end", data);
            } else {
                data.put("startTime", correspondingActivityStartData.get("startTime"));
                this.getAsyncHistorySession().addHistoricData("activity-full", data);
            }
        }
    }

    @Override
    public void recordProcessDefinitionChange(String processInstanceId, String processDefinitionId) {
        HashMap<String, String> data = new HashMap<String, String>();
        this.putIfNotNull(data, "processInstanceId", processInstanceId);
        this.putIfNotNull(data, "processDefinitionId", processDefinitionId);
        this.getAsyncHistorySession().addHistoricData("set-process-definition", data);
    }

    @Override
    public void recordTaskCreated(TaskEntity task, ExecutionEntity execution) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "id", task.getId());
            this.putIfNotNull(data, "name", task.getName());
            this.putIfNotNull(data, "parentTaskId", task.getParentTaskId());
            this.putIfNotNull(data, "description", task.getDescription());
            this.putIfNotNull(data, "owner", task.getOwner());
            this.putIfNotNull(data, "assignee", task.getAssignee());
            this.putIfNotNull(data, "startTime", this.getClock().getCurrentTime());
            this.putIfNotNull(data, "taskDefinitionKey", task.getTaskDefinitionKey());
            this.putIfNotNull(data, "priority", task.getPriority());
            if (task.getDueDate() != null) {
                this.putIfNotNull(data, "dueDate", task.getDueDate());
            }
            this.putIfNotNull(data, "category", task.getCategory());
            this.putIfNotNull(data, "tenantId", task.getTenantId());
            if (execution != null) {
                this.putIfNotNull(data, "processDefinitionId", execution.getProcessDefinitionId());
                this.putIfNotNull(data, "processInstanceId", execution.getProcessInstanceId());
                this.putIfNotNull(data, "executionId", execution.getId());
                this.putIfNotNull(data, "activityId", this.getActivityIdForExecution(execution));
            }
            this.getAsyncHistorySession().addHistoricData("task-created", data, task.getTenantId());
        }
    }

    @Override
    public void recordTaskEnd(TaskEntity task, ExecutionEntity execution, String deleteReason) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "id", task.getId());
            this.putIfNotNull(data, "name", task.getName());
            this.putIfNotNull(data, "parentTaskId", task.getParentTaskId());
            this.putIfNotNull(data, "description", task.getDescription());
            this.putIfNotNull(data, "owner", task.getOwner());
            this.putIfNotNull(data, "assignee", task.getAssignee());
            this.putIfNotNull(data, "startTime", this.getClock().getCurrentTime());
            this.putIfNotNull(data, "taskDefinitionKey", task.getTaskDefinitionKey());
            this.putIfNotNull(data, "priority", task.getPriority());
            this.putIfNotNull(data, "dueDate", task.getDueDate());
            this.putIfNotNull(data, "formKey", task.getFormKey());
            this.putIfNotNull(data, "category", task.getCategory());
            this.putIfNotNull(data, "claimTime", task.getClaimTime());
            this.putIfNotNull(data, "processDefinitionId", task.getProcessDefinitionId());
            this.putIfNotNull(data, "tenantId", task.getTenantId());
            if (execution != null) {
                this.putIfNotNull(data, "processDefinitionId", execution.getProcessDefinitionId());
                this.putIfNotNull(data, "processInstanceId", execution.getProcessInstanceId());
                this.putIfNotNull(data, "executionId", execution.getId());
                this.putIfNotNull(data, "activityId", this.getActivityIdForExecution(execution));
            }
            this.putIfNotNull(data, "deleteReason", deleteReason);
            this.putIfNotNull(data, "endTime", this.getClock().getCurrentTime());
            this.getAsyncHistorySession().addHistoricData("task-ended", data);
        }
    }

    @Override
    public void recordTaskInfoChange(TaskEntity taskEntity) {
        Map originalPersistentState;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "id", taskEntity.getId());
            this.putIfNotNull(data, "name", taskEntity.getName());
            this.putIfNotNull(data, "description", taskEntity.getDescription());
            this.putIfNotNull(data, "assignee", taskEntity.getAssignee());
            this.putIfNotNull(data, "owner", taskEntity.getOwner());
            this.putIfNotNull(data, "dueDate", taskEntity.getDueDate());
            this.putIfNotNull(data, "priority", taskEntity.getPriority());
            this.putIfNotNull(data, "category", taskEntity.getCategory());
            this.putIfNotNull(data, "formKey", taskEntity.getFormKey());
            this.putIfNotNull(data, "parentTaskId", taskEntity.getParentTaskId());
            this.putIfNotNull(data, "taskDefinitionKey", taskEntity.getTaskDefinitionKey());
            this.putIfNotNull(data, "processDefinitionId", taskEntity.getProcessDefinitionId());
            this.putIfNotNull(data, "claimTime", taskEntity.getClaimTime());
            this.getAsyncHistorySession().addHistoricData("task-property-changed", data);
        }
        if ((originalPersistentState = (Map)taskEntity.getOriginalPersistentState()) == null && taskEntity.getAssignee() != null || originalPersistentState != null && !Objects.equals(originalPersistentState.get("assignee"), taskEntity.getAssignee())) {
            this.handleTaskAssigneeChange(taskEntity);
        }
        if (originalPersistentState == null && taskEntity.getOwner() != null || originalPersistentState != null && !Objects.equals(originalPersistentState.get("owner"), taskEntity.getOwner())) {
            this.handleTaskOwnerChange(taskEntity);
        }
    }

    protected void handleTaskAssigneeChange(TaskEntity taskEntity) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "assignee", taskEntity.getAssignee());
            ExecutionEntity executionEntity = taskEntity.getExecution();
            if (executionEntity != null) {
                this.putIfNotNull(data, "executionId", executionEntity.getId());
                String activityId = this.getActivityIdForExecution(executionEntity);
                this.putIfNotNull(data, "activityId", activityId);
                Map<String, String> activityStartData = this.getActivityStart(executionEntity.getId(), activityId, false);
                if (activityStartData != null) {
                    this.putIfNotNull(activityStartData, "assignee", taskEntity.getAssignee());
                    data.put("activityAssigneeHandled", String.valueOf(true));
                }
            }
            if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
                this.putIfNotNull(data, "id", taskEntity.getId());
                this.putIfNotNull(data, "createTime", this.getClock().getCurrentTime());
                this.getAsyncHistorySession().addHistoricData("task-assignee-changed", data);
            }
        }
    }

    protected void handleTaskOwnerChange(TaskEntity taskEntity) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "id", taskEntity.getId());
            this.putIfNotNull(data, "owner", taskEntity.getOwner());
            this.putIfNotNull(data, "createTime", this.getClock().getCurrentTime());
            this.getAsyncHistorySession().addHistoricData("task-owner-changed", data);
        }
    }

    @Override
    public void recordVariableCreate(VariableInstanceEntity variable) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "id", variable.getId());
            this.putIfNotNull(data, "processInstanceId", variable.getProcessInstanceId());
            this.putIfNotNull(data, "executionId", variable.getExecutionId());
            this.putIfNotNull(data, "taskId", variable.getTaskId());
            this.putIfNotNull(data, "revision", variable.getRevision());
            this.putIfNotNull(data, "name", variable.getName());
            Date time = this.getClock().getCurrentTime();
            this.putIfNotNull(data, "createTime", time);
            this.putIfNotNull(data, "variableType", variable.getType().getTypeName());
            this.putIfNotNull(data, "variableTextValue", variable.getTextValue());
            this.putIfNotNull(data, "variableTextValue2", variable.getTextValue2());
            this.putIfNotNull(data, "variableDoubleValue", variable.getDoubleValue());
            this.putIfNotNull(data, "variableLongValue", variable.getLongValue());
            if (variable.getByteArrayRef() != null) {
                this.putIfNotNull(data, "variableBytesValue", Base64.encodeBase64String((byte[])variable.getBytes()));
            }
            this.getAsyncHistorySession().addHistoricData("variable-created", data);
        }
    }

    @Override
    public void recordHistoricDetailVariableCreate(VariableInstanceEntity variable, ExecutionEntity sourceActivityExecution, boolean useActivityId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.FULL)) {
            String activityId;
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "processInstanceId", variable.getProcessInstanceId());
            this.putIfNotNull(data, "executionId", variable.getExecutionId());
            this.putIfNotNull(data, "taskId", variable.getTaskId());
            this.putIfNotNull(data, "revision", variable.getRevision());
            this.putIfNotNull(data, "name", variable.getName());
            if (sourceActivityExecution != null && sourceActivityExecution.isMultiInstanceRoot()) {
                this.putIfNotNull(data, "isMiRootExecution", true);
            }
            Date time = this.getClock().getCurrentTime();
            this.putIfNotNull(data, "createTime", time);
            this.putIfNotNull(data, "variableType", variable.getType().getTypeName());
            this.putIfNotNull(data, "variableTextValue", variable.getTextValue());
            this.putIfNotNull(data, "variableTextValue2", variable.getTextValue2());
            this.putIfNotNull(data, "variableDoubleValue", variable.getDoubleValue());
            this.putIfNotNull(data, "variableLongValue", variable.getLongValue());
            if (variable.getBytes() != null) {
                this.putIfNotNull(data, "variableBytesValue", Base64.encodeBase64String((byte[])variable.getBytes()));
            }
            if (useActivityId && sourceActivityExecution != null && (activityId = this.getActivityIdForExecution(sourceActivityExecution)) != null) {
                this.putIfNotNull(data, "activityId", activityId);
                this.putIfNotNull(data, "sourceExecutionId", sourceActivityExecution.getId());
            }
            this.getAsyncHistorySession().addHistoricData("historic-detail-variable-update", data);
        }
    }

    @Override
    public void recordVariableUpdate(VariableInstanceEntity variable) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "id", variable.getId());
            Date time = this.getClock().getCurrentTime();
            this.putIfNotNull(data, "lastUpdatedTime", time);
            this.putIfNotNull(data, "variableType", variable.getType().getTypeName());
            this.putIfNotNull(data, "variableTextValue", variable.getTextValue());
            this.putIfNotNull(data, "variableTextValue2", variable.getTextValue2());
            this.putIfNotNull(data, "variableDoubleValue", variable.getDoubleValue());
            this.putIfNotNull(data, "variableLongValue", variable.getLongValue());
            if (variable.getByteArrayRef() != null) {
                this.putIfNotNull(data, "variableBytesValue", Base64.encodeBase64String((byte[])variable.getBytes()));
            }
            this.getAsyncHistorySession().addHistoricData("variable-updated", data);
        }
    }

    @Override
    public void recordVariableRemoved(VariableInstanceEntity variable) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "id", variable.getId());
            this.getAsyncHistorySession().addHistoricData("variable-removed", data);
        }
    }

    @Override
    public void recordFormPropertiesSubmitted(ExecutionEntity execution, Map<String, String> properties, String taskId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "processInstanceId", execution.getProcessInstanceId());
            this.putIfNotNull(data, "executionId", execution.getId());
            this.putIfNotNull(data, "taskId", taskId);
            String activityId = this.getActivityIdForExecution(execution);
            this.putIfNotNull(data, "activityId", activityId);
            Date currentTime = this.getClock().getCurrentTime();
            this.putIfNotNull(data, "createTime", currentTime);
            int counter = 1;
            for (String propertyId : properties.keySet()) {
                String propertyValue = properties.get(propertyId);
                data.put("formPropertyId" + counter, propertyId);
                data.put("formPropertyValue" + counter, propertyValue);
                ++counter;
            }
            this.getAsyncHistorySession().addHistoricData("form-properties-submitted", data);
        }
    }

    @Override
    public void recordIdentityLinkCreated(IdentityLinkEntity identityLink) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (identityLink.getProcessInstanceId() != null || identityLink.getTaskId() != null)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "id", identityLink.getId());
            this.putIfNotNull(data, "groupId", identityLink.getGroupId());
            this.putIfNotNull(data, "processInstanceId", identityLink.getProcessInstanceId());
            this.putIfNotNull(data, "taskId", identityLink.getTaskId());
            this.putIfNotNull(data, "identityLinkType", identityLink.getType());
            this.putIfNotNull(data, "userId", identityLink.getUserId());
            this.getAsyncHistorySession().addHistoricData("identitylink-created", data);
        }
    }

    @Override
    public void recordIdentityLinkDeleted(String identityLinkId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "id", identityLinkId);
            this.getAsyncHistorySession().addHistoricData("identitylink-deleted", data);
        }
    }

    @Override
    public void updateProcessBusinessKeyInHistory(ExecutionEntity processInstance) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HashMap<String, String> data = new HashMap<String, String>();
            this.putIfNotNull(data, "processInstanceId", processInstance.getId());
            this.putIfNotNull(data, "businessKey", processInstance.getBusinessKey());
            this.putIfNotNull(data, "property", "businessKey");
            this.getAsyncHistorySession().addHistoricData("process-instance-property-changed", data);
        }
    }

    protected Map<String, String> getActivityStart(String executionId, String activityId, boolean removeFromAsyncHistorySession) {
        Map<String, List<Map<String, String>>> jobData = this.getAsyncHistorySession().getJobData();
        if (jobData != null && jobData.containsKey("activity-start")) {
            List<Map<String, String>> activityStartDataList = jobData.get("activity-start");
            Iterator<Map<String, String>> activityStartDataIterator = activityStartDataList.iterator();
            while (activityStartDataIterator.hasNext()) {
                Map<String, String> activityStartData = activityStartDataIterator.next();
                if (!activityId.equals(activityStartData.get("activityId")) || !executionId.equals(activityStartData.get("executionId"))) continue;
                if (removeFromAsyncHistorySession) {
                    activityStartDataIterator.remove();
                }
                return activityStartData;
            }
        }
        return null;
    }

    protected void putIfNotNull(Map<String, String> map, String key, String value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    protected void putIfNotNull(Map<String, String> map, String key, int value) {
        map.put(key, Integer.toString(value));
    }

    protected void putIfNotNull(Map<String, String> map, String key, Double value) {
        if (value != null) {
            map.put(key, Double.toString(value));
        }
    }

    protected void putIfNotNull(Map<String, String> map, String key, Long value) {
        if (value != null) {
            map.put(key, Long.toString(value));
        }
    }

    protected void putIfNotNull(Map<String, String> map, String key, Date value) {
        if (value != null) {
            map.put(key, AsyncHistoryDateUtil.formatDate(value));
        }
    }

    protected void putIfNotNull(Map<String, String> map, String key, Boolean value) {
        if (value != null) {
            map.put(key, Boolean.toString(value));
        }
    }
}

