/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.async.AsyncHistoryListener;
import org.flowable.engine.impl.history.async.AsyncHistorySession;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.interceptor.CommandContextCloseListener;

public class AsyncHistorySessionCommandContextCloseListener
implements CommandContextCloseListener {
    public static List<String> TYPE_ORDER = Arrays.asList("process-instance-start", "process-instance-property-changed", "activity-start", "activity-end", "activity-full", "task-created", "task-assignee-changed", "task-owner-changed", "task-property-changed", "task-ended", "variable-created", "variable-updated", "variable-removed", "historic-detail-variable-update", "form-properties-submitted", "set-process-definition", "subprocess-instance-start", "identitylink-created", "identitylink-deleted", "process-instance-deleted-by-process-definition-id", "process-instance-deleted", "process-instance-end");
    protected AsyncHistorySession asyncHistorySession;
    protected AsyncHistoryListener asyncHistoryListener;

    public AsyncHistorySessionCommandContextCloseListener() {
    }

    public AsyncHistorySessionCommandContextCloseListener(AsyncHistorySession asyncHistorySession, AsyncHistoryListener asyncHistoryListener) {
        this.asyncHistorySession = asyncHistorySession;
        this.asyncHistoryListener = asyncHistoryListener;
    }

    @Override
    public void closing(CommandContext commandContext) {
        Map<String, List<Map<String, String>>> jobData = this.asyncHistorySession.getJobData();
        if (!jobData.isEmpty()) {
            ArrayList<ObjectNode> objectNodes = new ArrayList<ObjectNode>();
            for (String type : TYPE_ORDER) {
                if (!jobData.containsKey(type)) continue;
                this.generateJson(commandContext, jobData, objectNodes, type);
            }
            if (!jobData.isEmpty()) {
                for (String type : jobData.keySet()) {
                    this.generateJson(commandContext, jobData, objectNodes, type);
                }
            }
            this.asyncHistoryListener.historyDataGenerated(objectNodes);
        }
    }

    protected void generateJson(CommandContext commandContext, Map<String, List<Map<String, String>>> jobData, List<ObjectNode> objectNodes, String type) {
        List<Map<String, String>> historicDataList = jobData.get(type);
        for (Map<String, String> historicData : historicDataList) {
            ObjectNode historyJson = this.generateJson(commandContext, type, historicData);
            objectNodes.add(historyJson);
        }
        jobData.remove(type);
    }

    protected ObjectNode generateJson(CommandContext commandContext, String type, Map<String, String> historicData) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        ObjectNode elementObjectNode = processEngineConfiguration.getObjectMapper().createObjectNode();
        elementObjectNode.put("type", type);
        ObjectNode dataNode = elementObjectNode.putObject("data");
        for (String key : historicData.keySet()) {
            dataNode.put(key, historicData.get(key));
        }
        return elementObjectNode;
    }

    @Override
    public void closed(CommandContext commandContext) {
    }

    @Override
    public void closeFailure(CommandContext commandContext) {
    }

    @Override
    public void afterSessionsFlush(CommandContext commandContext) {
    }

    public AsyncHistorySession getAsyncHistorySession() {
        return this.asyncHistorySession;
    }

    public void setAsyncHistorySession(AsyncHistorySession asyncHistorySession) {
        this.asyncHistorySession = asyncHistorySession;
    }

    public AsyncHistoryListener getAsyncHistoryListener() {
        return this.asyncHistoryListener;
    }

    public void setAsyncHistoryListener(AsyncHistoryListener asyncHistoryListener) {
        this.asyncHistoryListener = asyncHistoryListener;
    }
}

