/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.flowable.engine.impl.history.async.json.transformer.AbstractProcessInstanceDeleteHistoryTransformer;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.HistoryJobEntity;

public class ProcessInstanceDeleteHistoryByProcessDefinitionIdJsonTransformer
extends AbstractProcessInstanceDeleteHistoryTransformer {
    @Override
    public String getType() {
        return "process-instance-deleted-by-process-definition-id";
    }

    @Override
    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        return true;
    }

    @Override
    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String processDefinitionId = this.getStringFromJson(historicalData, "processDefinitionId");
        List<String> processInstanceIds = commandContext.getHistoricProcessInstanceEntityManager().findHistoricProcessInstanceIdsByProcessDefinitionId(processDefinitionId);
        for (String processInstanceId : processInstanceIds) {
            this.deleteProcessInstance(processInstanceId, commandContext);
        }
    }
}

