/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.interceptor;

import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableOptimisticLockingException;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.flowable.engine.impl.interceptor.AbstractCommandInterceptor;
import org.flowable.engine.impl.interceptor.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryInterceptor
extends AbstractCommandInterceptor {
    private static Logger log = LoggerFactory.getLogger(RetryInterceptor.class);
    protected int numOfRetries = 3;
    protected int waitTimeInMs = 50;
    protected int waitIncreaseFactor = 5;

    @Override
    public <T> T execute(CommandConfig config, Command<T> command) {
        long waitTime = this.waitTimeInMs;
        int failedAttempts = 0;
        while (true) {
            if (failedAttempts > 0) {
                log.info("Waiting for {}ms before retrying the command.", (Object)waitTime);
                this.waitBeforeRetry(waitTime);
                waitTime *= (long)this.waitIncreaseFactor;
            }
            try {
                return this.next.execute(config, command);
            }
            catch (FlowableOptimisticLockingException e) {
                log.info("Caught optimistic locking exception: {}", (Object)e.getMessage(), (Object)e);
                if (++failedAttempts <= this.numOfRetries) continue;
                throw new FlowableException(this.numOfRetries + " retries failed with FlowableOptimisticLockingException. Giving up.");
            }
            break;
        }
    }

    protected void waitBeforeRetry(long waitTime) {
        try {
            Thread.sleep(waitTime);
        }
        catch (InterruptedException e) {
            log.debug("I am interrupted while waiting for a retry.");
        }
    }

    public void setNumOfRetries(int numOfRetries) {
        this.numOfRetries = numOfRetries;
    }

    public void setWaitIncreaseFactor(int waitIncreaseFactor) {
        this.waitIncreaseFactor = waitIncreaseFactor;
    }

    public void setWaitTimeInMs(int waitTimeInMs) {
        this.waitTimeInMs = waitTimeInMs;
    }

    public int getNumOfRetries() {
        return this.numOfRetries;
    }

    public int getWaitIncreaseFactor() {
        return this.waitIncreaseFactor;
    }

    public int getWaitTimeInMs() {
        return this.waitTimeInMs;
    }
}

