/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.repository;

import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.util.IoUtil;
import org.flowable.engine.impl.RepositoryServiceImpl;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.ResourceEntity;
import org.flowable.engine.impl.persistence.entity.ResourceEntityManager;
import org.flowable.engine.impl.util.ReflectUtil;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.DeploymentBuilder;

public class DeploymentBuilderImpl
implements DeploymentBuilder,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected transient RepositoryServiceImpl repositoryService;
    protected transient ResourceEntityManager resourceEntityManager;
    protected DeploymentEntity deployment;
    protected boolean isBpmn20XsdValidationEnabled = true;
    protected boolean isProcessValidationEnabled = true;
    protected boolean isDuplicateFilterEnabled;
    protected Date processDefinitionsActivationDate;
    protected Map<String, Object> deploymentProperties = new HashMap<String, Object>();

    public DeploymentBuilderImpl(RepositoryServiceImpl repositoryService) {
        this.repositoryService = repositoryService;
        this.deployment = (DeploymentEntity)Context.getProcessEngineConfiguration().getDeploymentEntityManager().create();
        this.resourceEntityManager = Context.getProcessEngineConfiguration().getResourceEntityManager();
    }

    @Override
    public DeploymentBuilder addInputStream(String resourceName, InputStream inputStream) {
        if (inputStream == null) {
            throw new FlowableIllegalArgumentException("inputStream for resource '" + resourceName + "' is null");
        }
        byte[] bytes = IoUtil.readInputStream((InputStream)inputStream, (String)resourceName);
        ResourceEntity resource = (ResourceEntity)this.resourceEntityManager.create();
        resource.setName(resourceName);
        resource.setBytes(bytes);
        this.deployment.addResource(resource);
        return this;
    }

    @Override
    public DeploymentBuilder addClasspathResource(String resource) {
        InputStream inputStream = ReflectUtil.getResourceAsStream(resource);
        if (inputStream == null) {
            throw new FlowableIllegalArgumentException("resource '" + resource + "' not found");
        }
        return this.addInputStream(resource, inputStream);
    }

    @Override
    public DeploymentBuilder addString(String resourceName, String text) {
        if (text == null) {
            throw new FlowableIllegalArgumentException("text is null");
        }
        ResourceEntity resource = (ResourceEntity)this.resourceEntityManager.create();
        resource.setName(resourceName);
        try {
            resource.setBytes(text.getBytes(DEFAULT_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new FlowableException("Unable to get process bytes.", (Throwable)e);
        }
        this.deployment.addResource(resource);
        return this;
    }

    @Override
    public DeploymentBuilder addBytes(String resourceName, byte[] bytes) {
        if (bytes == null) {
            throw new FlowableIllegalArgumentException("bytes is null");
        }
        ResourceEntity resource = (ResourceEntity)this.resourceEntityManager.create();
        resource.setName(resourceName);
        resource.setBytes(bytes);
        this.deployment.addResource(resource);
        return this;
    }

    @Override
    public DeploymentBuilder addZipInputStream(ZipInputStream zipInputStream) {
        try {
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    String entryName = entry.getName();
                    byte[] bytes = IoUtil.readInputStream((InputStream)zipInputStream, (String)entryName);
                    ResourceEntity resource = (ResourceEntity)this.resourceEntityManager.create();
                    resource.setName(entryName);
                    resource.setBytes(bytes);
                    this.deployment.addResource(resource);
                }
                entry = zipInputStream.getNextEntry();
            }
        }
        catch (Exception e) {
            throw new FlowableException("problem reading zip input stream", (Throwable)e);
        }
        return this;
    }

    @Override
    public DeploymentBuilder addBpmnModel(String resourceName, BpmnModel bpmnModel) {
        BpmnXMLConverter bpmnXMLConverter = new BpmnXMLConverter();
        try {
            String bpmn20Xml = new String(bpmnXMLConverter.convertToXML(bpmnModel), DEFAULT_ENCODING);
            this.addString(resourceName, bpmn20Xml);
        }
        catch (UnsupportedEncodingException e) {
            throw new FlowableException("Error while transforming BPMN model to xml: not UTF-8 encoded", (Throwable)e);
        }
        return this;
    }

    @Override
    public DeploymentBuilder name(String name) {
        this.deployment.setName(name);
        return this;
    }

    @Override
    public DeploymentBuilder category(String category) {
        this.deployment.setCategory(category);
        return this;
    }

    @Override
    public DeploymentBuilder key(String key) {
        this.deployment.setKey(key);
        return this;
    }

    @Override
    public DeploymentBuilder disableBpmnValidation() {
        this.isProcessValidationEnabled = false;
        return this;
    }

    @Override
    public DeploymentBuilder disableSchemaValidation() {
        this.isBpmn20XsdValidationEnabled = false;
        return this;
    }

    @Override
    public DeploymentBuilder tenantId(String tenantId) {
        this.deployment.setTenantId(tenantId);
        return this;
    }

    @Override
    public DeploymentBuilder enableDuplicateFiltering() {
        this.isDuplicateFilterEnabled = true;
        return this;
    }

    @Override
    public DeploymentBuilder activateProcessDefinitionsOn(Date date) {
        this.processDefinitionsActivationDate = date;
        return this;
    }

    @Override
    public DeploymentBuilder deploymentProperty(String propertyKey, Object propertyValue) {
        this.deploymentProperties.put(propertyKey, propertyValue);
        return this;
    }

    @Override
    public Deployment deploy() {
        return this.repositoryService.deploy(this);
    }

    public DeploymentEntity getDeployment() {
        return this.deployment;
    }

    public boolean isProcessValidationEnabled() {
        return this.isProcessValidationEnabled;
    }

    public boolean isBpmn20XsdValidationEnabled() {
        return this.isBpmn20XsdValidationEnabled;
    }

    public boolean isDuplicateFilterEnabled() {
        return this.isDuplicateFilterEnabled;
    }

    public Date getProcessDefinitionsActivationDate() {
        return this.processDefinitionsActivationDate;
    }

    public Map<String, Object> getDeploymentProperties() {
        return this.deploymentProperties;
    }
}

