/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.variable;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.impl.variable.SerializableType;
import org.flowable.engine.impl.variable.ValueFields;

public class LongJsonType
extends SerializableType {
    protected final int minLength;
    protected ObjectMapper objectMapper;

    public LongJsonType(int minLength, ObjectMapper objectMapper) {
        this.minLength = minLength;
        this.objectMapper = objectMapper;
    }

    @Override
    public String getTypeName() {
        return "longJson";
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        if (JsonNode.class.isAssignableFrom(value.getClass())) {
            JsonNode jsonValue = (JsonNode)value;
            return jsonValue.toString().length() >= this.minLength;
        }
        return false;
    }

    @Override
    public byte[] serialize(Object value, ValueFields valueFields) {
        if (value == null) {
            return null;
        }
        JsonNode valueNode = (JsonNode)value;
        try {
            return valueNode.toString().getBytes("utf-8");
        }
        catch (Exception e) {
            throw new FlowableException("Error getting bytes from json variable", (Throwable)e);
        }
    }

    @Override
    public Object deserialize(byte[] bytes, ValueFields valueFields) {
        JsonNode valueNode = null;
        try {
            valueNode = this.objectMapper.readTree(bytes);
        }
        catch (Exception e) {
            throw new FlowableException("Error reading json variable", (Throwable)e);
        }
        return valueNode;
    }
}

