/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.variable;

import org.flowable.engine.impl.variable.ValueFields;
import org.flowable.engine.impl.variable.VariableType;

public class StringType
implements VariableType {
    private final int maxLength;

    public StringType(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public String getTypeName() {
        return "string";
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        return valueFields.getTextValue();
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        valueFields.setTextValue((String)value);
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            String stringValue = (String)value;
            return stringValue.length() <= this.maxLength;
        }
        return false;
    }
}

