/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.test.profiler;

import org.flowable.engine.common.impl.interceptor.AbstractCommandInterceptor;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.flowable.engine.test.profiler.CommandExecutionResult;
import org.flowable.engine.test.profiler.FlowableProfiler;
import org.flowable.engine.test.profiler.ProfileSession;

public class TotalExecutionTimeCommandInterceptor
extends AbstractCommandInterceptor {
    protected FlowableProfiler profiler = FlowableProfiler.getInstance();

    public <T> T execute(CommandConfig config, Command<T> command) {
        ProfileSession currentProfileSession = this.profiler.getCurrentProfileSession();
        if (currentProfileSession != null) {
            String className = command.getClass().getName();
            CommandExecutionResult commandExecutionResult = new CommandExecutionResult();
            currentProfileSession.setCurrentCommandExecution(commandExecutionResult);
            commandExecutionResult.setCommandFqn(className);
            long start = System.currentTimeMillis();
            Object result = this.next.execute(config, command);
            long end = System.currentTimeMillis();
            long totalTime = end - start;
            commandExecutionResult.setTotalTimeInMs(totalTime);
            currentProfileSession.addCommandExecution(className, commandExecutionResult);
            currentProfileSession.clearCurrentCommandExecution();
            return (T)result;
        }
        return (T)this.next.execute(config, command);
    }
}

