/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl;

import java.util.List;
import org.flowable.engine.common.api.history.HistoricData;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.interceptor.CommandExecutor;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricDetail;
import org.flowable.engine.history.HistoricVariableUpdate;
import org.flowable.engine.history.ProcessInstanceHistoryLog;
import org.flowable.engine.history.ProcessInstanceHistoryLogQuery;
import org.flowable.engine.impl.HistoricActivityInstanceQueryImpl;
import org.flowable.engine.impl.HistoricDetailQueryImpl;
import org.flowable.engine.impl.ProcessInstanceHistoryLogImpl;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.task.Comment;
import org.flowable.task.service.impl.HistoricTaskInstanceQueryImpl;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.flowable.variable.service.impl.HistoricVariableInstanceQueryImpl;
import org.flowable.variable.service.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.flowable.variable.service.impl.types.CacheableVariable;

public class ProcessInstanceHistoryLogQueryImpl
implements ProcessInstanceHistoryLogQuery,
Command<ProcessInstanceHistoryLog> {
    protected CommandExecutor commandExecutor;
    protected String processInstanceId;
    protected boolean includeTasks;
    protected boolean includeActivities;
    protected boolean includeVariables;
    protected boolean includeComments;
    protected boolean includeVariableUpdates;
    protected boolean includeFormProperties;

    public ProcessInstanceHistoryLogQueryImpl(CommandExecutor commandExecutor, String processInstanceId) {
        this.commandExecutor = commandExecutor;
        this.processInstanceId = processInstanceId;
    }

    @Override
    public ProcessInstanceHistoryLogQuery includeTasks() {
        this.includeTasks = true;
        return this;
    }

    @Override
    public ProcessInstanceHistoryLogQuery includeComments() {
        this.includeComments = true;
        return this;
    }

    @Override
    public ProcessInstanceHistoryLogQuery includeActivities() {
        this.includeActivities = true;
        return this;
    }

    @Override
    public ProcessInstanceHistoryLogQuery includeVariables() {
        this.includeVariables = true;
        return this;
    }

    @Override
    public ProcessInstanceHistoryLogQuery includeVariableUpdates() {
        this.includeVariableUpdates = true;
        return this;
    }

    @Override
    public ProcessInstanceHistoryLogQuery includeFormProperties() {
        this.includeFormProperties = true;
        return this;
    }

    @Override
    public ProcessInstanceHistoryLog singleResult() {
        return (ProcessInstanceHistoryLog)this.commandExecutor.execute((Command)this);
    }

    public ProcessInstanceHistoryLog execute(CommandContext commandContext) {
        HistoricProcessInstanceEntity historicProcessInstance = (HistoricProcessInstanceEntity)CommandContextUtil.getHistoricProcessInstanceEntityManager(commandContext).findById(this.processInstanceId);
        if (historicProcessInstance == null) {
            return null;
        }
        ProcessInstanceHistoryLogImpl processInstanceHistoryLog = new ProcessInstanceHistoryLogImpl(historicProcessInstance);
        if (this.includeTasks) {
            List tasks = CommandContextUtil.getHistoricTaskService().findHistoricTaskInstancesByQueryCriteria(new HistoricTaskInstanceQueryImpl(this.commandExecutor).processInstanceId(this.processInstanceId));
            processInstanceHistoryLog.addHistoricData(tasks);
        }
        if (this.includeActivities) {
            List<HistoricActivityInstance> activities = CommandContextUtil.getHistoricActivityInstanceEntityManager(commandContext).findHistoricActivityInstancesByQueryCriteria(new HistoricActivityInstanceQueryImpl(this.commandExecutor).processInstanceId(this.processInstanceId));
            processInstanceHistoryLog.addHistoricData(activities);
        }
        if (this.includeVariables) {
            List variables = CommandContextUtil.getHistoricVariableService().findHistoricVariableInstancesByQueryCriteria(new HistoricVariableInstanceQueryImpl(this.commandExecutor).processInstanceId(this.processInstanceId));
            for (HistoricVariableInstance historicVariableInstance : variables) {
                historicVariableInstance.getValue();
                HistoricVariableInstanceEntity variableEntity = (HistoricVariableInstanceEntity)historicVariableInstance;
                if (!"jpa-entity".equals(variableEntity.getVariableType().getTypeName()) && !"jpa-entity-list".equals(variableEntity.getVariableType().getTypeName())) continue;
                ((CacheableVariable)variableEntity.getVariableType()).setForceCacheable(true);
            }
            processInstanceHistoryLog.addHistoricData(variables);
        }
        if (this.includeComments) {
            List<Comment> comments = CommandContextUtil.getCommentEntityManager(commandContext).findCommentsByProcessInstanceId(this.processInstanceId);
            processInstanceHistoryLog.addHistoricData(comments);
        }
        if (this.includeVariableUpdates) {
            List<HistoricDetail> variableUpdates = CommandContextUtil.getHistoricDetailEntityManager(commandContext).findHistoricDetailsByQueryCriteria(new HistoricDetailQueryImpl(this.commandExecutor).variableUpdates());
            for (HistoricData historicData : variableUpdates) {
                HistoricVariableUpdate variableUpdate = (HistoricVariableUpdate)historicData;
                variableUpdate.getValue();
            }
            processInstanceHistoryLog.addHistoricData(variableUpdates);
        }
        if (this.includeFormProperties) {
            List<HistoricDetail> formProperties = CommandContextUtil.getHistoricDetailEntityManager(commandContext).findHistoricDetailsByQueryCriteria(new HistoricDetailQueryImpl(this.commandExecutor).formProperties());
            processInstanceHistoryLog.addHistoricData(formProperties);
        }
        processInstanceHistoryLog.orderHistoricData();
        return processInstanceHistoryLog;
    }
}

