/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.delegate.Expression;
import org.flowable.engine.common.api.delegate.event.FlowableEngineEventType;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.api.variable.VariableContainer;
import org.flowable.engine.common.impl.calendar.BusinessCalendar;
import org.flowable.engine.common.impl.el.ExpressionManager;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.IdentityLinkUtil;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.event.impl.FlowableTaskEventBuilder;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTaskActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(UserTaskActivityBehavior.class);
    protected UserTask userTask;

    public UserTaskActivityBehavior(UserTask userTask) {
        this.userTask = userTask;
    }

    @Override
    public void execute(DelegateExecution execution) {
        Object formKey;
        Object category;
        Object priority;
        Object dueDate;
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        TaskService taskService = CommandContextUtil.getTaskService(commandContext);
        TaskEntity task = taskService.createTask();
        task.setExecutionId(execution.getId());
        task.setTaskDefinitionKey(this.userTask.getId());
        String activeTaskName = null;
        String activeTaskDescription = null;
        String activeTaskDueDate = null;
        String activeTaskPriority = null;
        String activeTaskCategory = null;
        String activeTaskFormKey = null;
        String activeTaskSkipExpression = null;
        String activeTaskAssignee = null;
        String activeTaskOwner = null;
        List<String> activeTaskCandidateUsers = null;
        List<String> activeTaskCandidateGroups = null;
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        if (CommandContextUtil.getProcessEngineConfiguration(commandContext).isEnableProcessDefinitionInfoCache()) {
            ObjectNode taskElementProperties = BpmnOverrideContext.getBpmnOverrideElementProperties(this.userTask.getId(), execution.getProcessDefinitionId());
            activeTaskName = this.getActiveValue(this.userTask.getName(), "userTaskName", taskElementProperties);
            activeTaskDescription = this.getActiveValue(this.userTask.getDocumentation(), "userTaskDescription", taskElementProperties);
            activeTaskDueDate = this.getActiveValue(this.userTask.getDueDate(), "userTaskDueDate", taskElementProperties);
            activeTaskPriority = this.getActiveValue(this.userTask.getPriority(), "userTaskPriority", taskElementProperties);
            activeTaskCategory = this.getActiveValue(this.userTask.getCategory(), "userTaskCategory", taskElementProperties);
            activeTaskFormKey = this.getActiveValue(this.userTask.getFormKey(), "userTaskFormKey", taskElementProperties);
            activeTaskSkipExpression = this.getActiveValue(this.userTask.getSkipExpression(), "taskSkipExpression", taskElementProperties);
            activeTaskAssignee = this.getActiveValue(this.userTask.getAssignee(), "userTaskAssignee", taskElementProperties);
            activeTaskOwner = this.getActiveValue(this.userTask.getOwner(), "userTaskOwner", taskElementProperties);
            activeTaskCandidateUsers = this.getActiveValueList(this.userTask.getCandidateUsers(), "userTaskCandidateUsers", taskElementProperties);
            activeTaskCandidateGroups = this.getActiveValueList(this.userTask.getCandidateGroups(), "userTaskCandidateGroups", taskElementProperties);
        } else {
            activeTaskName = this.userTask.getName();
            activeTaskDescription = this.userTask.getDocumentation();
            activeTaskDueDate = this.userTask.getDueDate();
            activeTaskPriority = this.userTask.getPriority();
            activeTaskCategory = this.userTask.getCategory();
            activeTaskFormKey = this.userTask.getFormKey();
            activeTaskSkipExpression = this.userTask.getSkipExpression();
            activeTaskAssignee = this.userTask.getAssignee();
            activeTaskOwner = this.userTask.getOwner();
            activeTaskCandidateUsers = this.userTask.getCandidateUsers();
            activeTaskCandidateGroups = this.userTask.getCandidateGroups();
        }
        if (StringUtils.isNotEmpty((CharSequence)activeTaskName)) {
            String name = null;
            try {
                name = (String)expressionManager.createExpression(activeTaskName).getValue((VariableContainer)execution);
            }
            catch (FlowableException e) {
                name = activeTaskName;
                LOGGER.warn("property not found in task name expression {}", (Object)e.getMessage());
            }
            task.setName(name);
        }
        if (StringUtils.isNotEmpty((CharSequence)activeTaskDescription)) {
            String description = null;
            try {
                description = (String)expressionManager.createExpression(activeTaskDescription).getValue((VariableContainer)execution);
            }
            catch (FlowableException e) {
                description = activeTaskDescription;
                LOGGER.warn("property not found in task description expression {}", (Object)e.getMessage());
            }
            task.setDescription(description);
        }
        if (StringUtils.isNotEmpty((CharSequence)activeTaskDueDate) && (dueDate = expressionManager.createExpression(activeTaskDueDate).getValue((VariableContainer)execution)) != null) {
            if (dueDate instanceof Date) {
                task.setDueDate((Date)dueDate);
            } else if (dueDate instanceof String) {
                String businessCalendarName = null;
                businessCalendarName = StringUtils.isNotEmpty((CharSequence)this.userTask.getBusinessCalendarName()) ? expressionManager.createExpression(this.userTask.getBusinessCalendarName()).getValue((VariableContainer)execution).toString() : "dueDate";
                BusinessCalendar businessCalendar = CommandContextUtil.getProcessEngineConfiguration(commandContext).getBusinessCalendarManager().getBusinessCalendar(businessCalendarName);
                task.setDueDate(businessCalendar.resolveDuedate((String)dueDate));
            } else {
                throw new FlowableIllegalArgumentException("Due date expression does not resolve to a Date or Date string: " + activeTaskDueDate);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)activeTaskPriority) && (priority = expressionManager.createExpression(activeTaskPriority).getValue((VariableContainer)execution)) != null) {
            if (priority instanceof String) {
                try {
                    task.setPriority(Integer.valueOf((String)priority).intValue());
                }
                catch (NumberFormatException e) {
                    throw new FlowableIllegalArgumentException("Priority does not resolve to a number: " + priority, (Throwable)e);
                }
            } else if (priority instanceof Number) {
                task.setPriority(((Number)priority).intValue());
            } else {
                throw new FlowableIllegalArgumentException("Priority expression does not resolve to a number: " + activeTaskPriority);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)activeTaskCategory) && (category = expressionManager.createExpression(activeTaskCategory).getValue((VariableContainer)execution)) != null) {
            if (category instanceof String) {
                task.setCategory((String)category);
            } else {
                throw new FlowableIllegalArgumentException("Category expression does not resolve to a string: " + activeTaskCategory);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)activeTaskFormKey) && (formKey = expressionManager.createExpression(activeTaskFormKey).getValue((VariableContainer)execution)) != null) {
            if (formKey instanceof String) {
                task.setFormKey((String)formKey);
            } else {
                throw new FlowableIllegalArgumentException("FormKey expression does not resolve to a string: " + activeTaskFormKey);
            }
        }
        boolean skipUserTask = false;
        if (StringUtils.isNotEmpty((CharSequence)activeTaskSkipExpression)) {
            Expression skipExpression = expressionManager.createExpression(activeTaskSkipExpression);
            skipUserTask = SkipExpressionUtil.isSkipExpressionEnabled(execution, skipExpression) && SkipExpressionUtil.shouldSkipFlowElement(execution, skipExpression);
        }
        TaskHelper.insertTask(task, (ExecutionEntity)execution, !skipUserTask);
        if (!skipUserTask) {
            this.handleAssignments(taskService, activeTaskAssignee, activeTaskOwner, activeTaskCandidateUsers, activeTaskCandidateGroups, task, expressionManager, execution);
            processEngineConfiguration.getListenerNotificationHelper().executeTaskListeners(task, "create");
            if (CommandContextUtil.getTaskServiceConfiguration(commandContext).getEventDispatcher().isEnabled()) {
                CommandContextUtil.getTaskServiceConfiguration(commandContext).getEventDispatcher().dispatchEvent((FlowableEvent)FlowableTaskEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.TASK_CREATED, (Object)task));
            }
        } else {
            TaskHelper.deleteTask(task, null, false, false);
            this.leave(execution);
        }
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        List taskEntities = CommandContextUtil.getTaskService().findTasksByExecutionId(execution.getId());
        for (TaskEntity taskEntity : taskEntities) {
            if (taskEntity.isDeleted()) continue;
            throw new FlowableException("UserTask should not be signalled before complete");
        }
        this.leave(execution);
    }

    protected void handleAssignments(TaskService taskService, String assignee, String owner, List<String> candidateUsers, List<String> candidateGroups, TaskEntity task, ExpressionManager expressionManager, DelegateExecution execution) {
        IdentityLinkEntity identityLinkEntity;
        IdentityLinkEntity identityLinkEntity2;
        Object value;
        Expression idExpression;
        List identityLinkEntities;
        List identityLinkEntities2;
        List<String> candidates;
        String strValue;
        Object value2;
        if (StringUtils.isNotEmpty((CharSequence)assignee)) {
            Object assigneeExpressionValue = expressionManager.createExpression(assignee).getValue((VariableContainer)execution);
            String assigneeValue = null;
            if (assigneeExpressionValue != null) {
                assigneeValue = assigneeExpressionValue.toString();
            }
            if (StringUtils.isNotEmpty(assigneeValue)) {
                TaskHelper.changeTaskAssignee(task, assigneeValue);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)owner)) {
            Object ownerExpressionValue = expressionManager.createExpression(owner).getValue((VariableContainer)execution);
            String ownerValue = null;
            if (ownerExpressionValue != null) {
                ownerValue = ownerExpressionValue.toString();
            }
            if (StringUtils.isNotEmpty(ownerValue)) {
                TaskHelper.changeTaskOwner(task, ownerValue);
            }
        }
        if (candidateGroups != null && !candidateGroups.isEmpty()) {
            for (String candidateGroup : candidateGroups) {
                Expression groupIdExpr = expressionManager.createExpression(candidateGroup);
                value2 = groupIdExpr.getValue((VariableContainer)execution);
                if (value2 == null) continue;
                if (value2 instanceof String) {
                    strValue = (String)value2;
                    if (!StringUtils.isNotEmpty((CharSequence)strValue)) continue;
                    candidates = this.extractCandidates(strValue);
                    identityLinkEntities2 = CommandContextUtil.getIdentityLinkService().addCandidateGroups(task.getId(), candidates);
                    IdentityLinkUtil.handleTaskIdentityLinkAdditions(task, identityLinkEntities2);
                    continue;
                }
                if (value2 instanceof Collection) {
                    identityLinkEntities = CommandContextUtil.getIdentityLinkService().addCandidateGroups(task.getId(), (Collection)value2);
                    IdentityLinkUtil.handleTaskIdentityLinkAdditions(task, identityLinkEntities);
                    continue;
                }
                throw new FlowableIllegalArgumentException("Expression did not resolve to a string or collection of strings");
            }
        }
        if (candidateUsers != null && !candidateUsers.isEmpty()) {
            for (String candidateUser : candidateUsers) {
                Expression userIdExpr = expressionManager.createExpression(candidateUser);
                value2 = userIdExpr.getValue((VariableContainer)execution);
                if (value2 == null) continue;
                if (value2 instanceof String) {
                    strValue = (String)value2;
                    if (!StringUtils.isNotEmpty((CharSequence)strValue)) continue;
                    candidates = this.extractCandidates(strValue);
                    identityLinkEntities2 = CommandContextUtil.getIdentityLinkService().addCandidateUsers(task.getId(), candidates);
                    IdentityLinkUtil.handleTaskIdentityLinkAdditions(task, identityLinkEntities2);
                    continue;
                }
                if (value2 instanceof Collection) {
                    identityLinkEntities = CommandContextUtil.getIdentityLinkService().addCandidateUsers(task.getId(), (Collection)value2);
                    IdentityLinkUtil.handleTaskIdentityLinkAdditions(task, identityLinkEntities);
                    continue;
                }
                throw new FlowableException("Expression did not resolve to a string or collection of strings");
            }
        }
        if (this.userTask.getCustomUserIdentityLinks() != null && !this.userTask.getCustomUserIdentityLinks().isEmpty()) {
            for (String customUserIdentityLinkType : this.userTask.getCustomUserIdentityLinks().keySet()) {
                for (String userIdentityLink : (Set)this.userTask.getCustomUserIdentityLinks().get(customUserIdentityLinkType)) {
                    idExpression = expressionManager.createExpression(userIdentityLink);
                    value = idExpression.getValue((VariableContainer)execution);
                    if (value instanceof String) {
                        List<String> userIds = this.extractCandidates((String)value);
                        for (String userId : userIds) {
                            identityLinkEntity2 = CommandContextUtil.getIdentityLinkService().createTaskIdentityLink(task.getId(), userId, null, customUserIdentityLinkType);
                            IdentityLinkUtil.handleTaskIdentityLinkAddition(task, identityLinkEntity2);
                        }
                        continue;
                    }
                    if (value instanceof Collection) {
                        Iterator userIdSet = ((Collection)value).iterator();
                        while (userIdSet.hasNext()) {
                            identityLinkEntity = CommandContextUtil.getIdentityLinkService().createTaskIdentityLink(task.getId(), (String)userIdSet.next(), null, customUserIdentityLinkType);
                            IdentityLinkUtil.handleTaskIdentityLinkAddition(task, identityLinkEntity);
                        }
                        continue;
                    }
                    throw new FlowableException("Expression did not resolve to a string or collection of strings");
                }
            }
        }
        if (this.userTask.getCustomGroupIdentityLinks() != null && !this.userTask.getCustomGroupIdentityLinks().isEmpty()) {
            for (String customGroupIdentityLinkType : this.userTask.getCustomGroupIdentityLinks().keySet()) {
                for (String groupIdentityLink : (Set)this.userTask.getCustomGroupIdentityLinks().get(customGroupIdentityLinkType)) {
                    idExpression = expressionManager.createExpression(groupIdentityLink);
                    value = idExpression.getValue((VariableContainer)execution);
                    if (value instanceof String) {
                        List<String> groupIds = this.extractCandidates((String)value);
                        for (String groupId : groupIds) {
                            identityLinkEntity2 = CommandContextUtil.getIdentityLinkService().createTaskIdentityLink(task.getId(), null, groupId, customGroupIdentityLinkType);
                            IdentityLinkUtil.handleTaskIdentityLinkAddition(task, identityLinkEntity2);
                        }
                        continue;
                    }
                    if (value instanceof Collection) {
                        Iterator groupIdSet = ((Collection)value).iterator();
                        while (groupIdSet.hasNext()) {
                            identityLinkEntity = CommandContextUtil.getIdentityLinkService().createTaskIdentityLink(task.getId(), null, (String)groupIdSet.next(), customGroupIdentityLinkType);
                            IdentityLinkUtil.handleTaskIdentityLinkAddition(task, identityLinkEntity);
                        }
                        continue;
                    }
                    throw new FlowableException("Expression did not resolve to a string or collection of strings");
                }
            }
        }
    }

    protected List<String> extractCandidates(String str) {
        return Arrays.asList(str.split("[\\s]*,[\\s]*"));
    }
}

