/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.history.async.json.transformer.AbstractNeedsUnfinishedHistoricActivityHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class ActivityEndHistoryJsonTransformer
extends AbstractNeedsUnfinishedHistoricActivityHistoryJsonTransformer {
    public String getType() {
        return "activity-end";
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String activityId;
        String executionId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"executionId");
        HistoricActivityInstanceEntity historicActivityInstanceEntity = this.findUnfinishedHistoricActivityInstance(commandContext, executionId, activityId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"activityId"));
        if (historicActivityInstanceEntity != null) {
            Date endTime = AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"endTime");
            historicActivityInstanceEntity.setEndTime(endTime);
            historicActivityInstanceEntity.setDeleteReason(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"deleteReason"));
            Date startTime = historicActivityInstanceEntity.getStartTime();
            if (startTime != null && endTime != null) {
                historicActivityInstanceEntity.setDurationInMillis(endTime.getTime() - startTime.getTime());
            }
            this.dispatchEvent(commandContext, (FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_ACTIVITY_INSTANCE_ENDED, historicActivityInstanceEntity));
        }
    }
}

