/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Base64;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricDetailEntityManager;
import org.flowable.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.flowable.engine.impl.persistence.entity.data.HistoricDetailDataManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.api.types.VariableTypes;

public class HistoricDetailVariableUpdateHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    public String getType() {
        return "historic-detail-variable-update";
    }

    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        HistoricActivityInstanceEntity activityInstance;
        String activityId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"activityId");
        Boolean isMiRootExecution = AsyncHistoryJsonUtil.getBooleanFromJson((ObjectNode)historicalData, (String)"isMiRootExecution", (Boolean)false);
        return isMiRootExecution != false || !StringUtils.isNotEmpty((CharSequence)activityId) || (activityInstance = this.findHistoricActivityInstance(commandContext, AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"sourceExecutionId"), activityId)) != null;
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricActivityInstanceEntity activityInstance;
        HistoricDetailDataManager historicDetailDataManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getHistoricDetailDataManager();
        HistoricDetailVariableInstanceUpdateEntity historicDetailEntity = historicDetailDataManager.createHistoricDetailVariableInstanceUpdate();
        historicDetailEntity.setProcessInstanceId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processInstanceId"));
        historicDetailEntity.setExecutionId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"executionId"));
        historicDetailEntity.setTaskId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"taskId"));
        historicDetailEntity.setRevision(AsyncHistoryJsonUtil.getIntegerFromJson((ObjectNode)historicalData, (String)"revision"));
        historicDetailEntity.setName(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"name"));
        String activityId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"activityId");
        Boolean isMiRootExecution = AsyncHistoryJsonUtil.getBooleanFromJson((ObjectNode)historicalData, (String)"isMiRootExecution", (Boolean)false);
        if (!isMiRootExecution.booleanValue() && StringUtils.isNotEmpty((CharSequence)activityId) && (activityInstance = this.findHistoricActivityInstance(commandContext, AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"sourceExecutionId"), activityId)) != null) {
            historicDetailEntity.setActivityInstanceId(activityInstance.getId());
        }
        VariableTypes variableTypes = CommandContextUtil.getProcessEngineConfiguration().getVariableTypes();
        VariableType variableType = variableTypes.getVariableType(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"variableType"));
        historicDetailEntity.setVariableType(variableType);
        historicDetailEntity.setTextValue(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"variableTextValue"));
        historicDetailEntity.setTextValue2(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"variableTextValue2"));
        historicDetailEntity.setDoubleValue(AsyncHistoryJsonUtil.getDoubleFromJson((ObjectNode)historicalData, (String)"variableDoubleValue"));
        historicDetailEntity.setLongValue(AsyncHistoryJsonUtil.getLongFromJson((ObjectNode)historicalData, (String)"variableLongValue"));
        String variableBytes = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"variableBytesValue");
        if (StringUtils.isNotEmpty((CharSequence)variableBytes)) {
            historicDetailEntity.setBytes(Base64.getDecoder().decode(variableBytes));
        }
        Date time = AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"createTime");
        historicDetailEntity.setTime(time);
        HistoricDetailEntityManager historicDetailEntityManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getHistoricDetailEntityManager();
        historicDetailEntityManager.insert(historicDetailEntity);
    }
}

