/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.deploy;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.engine.impl.persistence.deploy.ProcessDefinitionInfoCacheObject;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionInfoEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionInfoEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDefinitionInfoCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessDefinitionInfoCache.class);
    protected Map<String, ProcessDefinitionInfoCacheObject> cache;
    protected CommandExecutor commandExecutor;

    public ProcessDefinitionInfoCache(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        this.cache = Collections.synchronizedMap(new HashMap());
    }

    public ProcessDefinitionInfoCache(CommandExecutor commandExecutor, final int limit) {
        this.commandExecutor = commandExecutor;
        this.cache = Collections.synchronizedMap(new LinkedHashMap<String, ProcessDefinitionInfoCacheObject>(limit + 1, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, ProcessDefinitionInfoCacheObject> eldest) {
                boolean removeEldest;
                boolean bl = removeEldest = this.size() > limit;
                if (removeEldest) {
                    LOGGER.trace("Cache limit is reached, {} will be evicted", (Object)eldest.getKey());
                }
                return removeEldest;
            }
        });
    }

    public ProcessDefinitionInfoCacheObject get(final String processDefinitionId) {
        ProcessDefinitionInfoCacheObject infoCacheObject = null;
        Command<ProcessDefinitionInfoCacheObject> cacheCommand = new Command<ProcessDefinitionInfoCacheObject>(){

            public ProcessDefinitionInfoCacheObject execute(CommandContext commandContext) {
                return ProcessDefinitionInfoCache.this.retrieveProcessDefinitionInfoCacheObject(processDefinitionId, commandContext);
            }
        };
        infoCacheObject = Context.getCommandContext() != null ? this.retrieveProcessDefinitionInfoCacheObject(processDefinitionId, Context.getCommandContext()) : (ProcessDefinitionInfoCacheObject)this.commandExecutor.execute((Command)cacheCommand);
        return infoCacheObject;
    }

    public void add(String id, ProcessDefinitionInfoCacheObject obj) {
        this.cache.put(id, obj);
    }

    public void remove(String id) {
        this.cache.remove(id);
    }

    public void clear() {
        this.cache.clear();
    }

    public int size() {
        return this.cache.size();
    }

    protected ProcessDefinitionInfoCacheObject retrieveProcessDefinitionInfoCacheObject(String processDefinitionId, CommandContext commandContext) {
        ProcessDefinitionInfoEntityManager infoEntityManager = CommandContextUtil.getProcessDefinitionInfoEntityManager(commandContext);
        ObjectMapper objectMapper = CommandContextUtil.getProcessEngineConfiguration(commandContext).getObjectMapper();
        ProcessDefinitionInfoCacheObject cacheObject = null;
        if (this.cache.containsKey(processDefinitionId)) {
            cacheObject = this.cache.get(processDefinitionId);
        } else {
            cacheObject = new ProcessDefinitionInfoCacheObject();
            cacheObject.setRevision(0);
            cacheObject.setInfoNode(objectMapper.createObjectNode());
        }
        ProcessDefinitionInfoEntity infoEntity = infoEntityManager.findProcessDefinitionInfoByProcessDefinitionId(processDefinitionId);
        if (infoEntity != null && infoEntity.getRevision() != cacheObject.getRevision()) {
            cacheObject.setRevision(infoEntity.getRevision());
            if (infoEntity.getInfoJsonId() != null) {
                byte[] infoBytes = infoEntityManager.findInfoJsonById(infoEntity.getInfoJsonId());
                try {
                    ObjectNode infoNode = (ObjectNode)objectMapper.readTree(infoBytes);
                    cacheObject.setInfoNode(infoNode);
                }
                catch (Exception e) {
                    throw new FlowableException("Error reading json info node for process definition " + processDefinitionId, (Throwable)e);
                }
            }
        } else if (infoEntity == null) {
            cacheObject.setRevision(0);
            cacheObject.setInfoNode(objectMapper.createObjectNode());
        }
        return cacheObject;
    }
}

