/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.test;

import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.cfg.CommandExecutorImpl;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.interceptor.CommandInterceptor;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngines;
import org.flowable.engine.impl.ProcessEngineImpl;
import org.flowable.engine.impl.interceptor.CommandInvoker;
import org.flowable.engine.impl.interceptor.LoggingExecutionTreeCommandInvoker;
import org.flowable.engine.impl.test.AbstractFlowableTestCase;
import org.flowable.engine.test.EnableVerboseExecutionTreeLogging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PluggableFlowableTestCase
extends AbstractFlowableTestCase {
    private static final Logger pluggableActivitiTestCaseLogger = LoggerFactory.getLogger(PluggableFlowableTestCase.class);
    protected static ProcessEngine cachedProcessEngine;

    @Override
    protected void initializeProcessEngine() {
        if (cachedProcessEngine == null) {
            pluggableActivitiTestCaseLogger.info("No cached process engine found for test. Retrieving the default engine.");
            ProcessEngines.destroy();
            cachedProcessEngine = ProcessEngines.getDefaultProcessEngine();
            if (cachedProcessEngine == null) {
                throw new FlowableException("no default process engine available");
            }
        }
        this.processEngine = cachedProcessEngine;
        this.processEngineConfiguration = ((ProcessEngineImpl)this.processEngine).getProcessEngineConfiguration();
        if (((Object)((Object)this)).getClass().isAnnotationPresent(EnableVerboseExecutionTreeLogging.class)) {
            this.swapCommandInvoker(true);
        }
    }

    @Override
    protected void closeDownProcessEngine() {
        super.closeDownProcessEngine();
        if (((Object)((Object)this)).getClass().isAnnotationPresent(EnableVerboseExecutionTreeLogging.class)) {
            this.swapCommandInvoker(false);
        }
    }

    protected void swapCommandInvoker(boolean debug) {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutor();
        if (commandExecutor instanceof CommandExecutorImpl) {
            CommandExecutorImpl commandExecutorImpl = (CommandExecutorImpl)commandExecutor;
            CommandInterceptor previousCommandInterceptor = null;
            for (CommandInterceptor commandInterceptor = commandExecutorImpl.getFirst(); commandInterceptor != null; commandInterceptor = commandInterceptor.getNext()) {
                boolean matches;
                boolean bl = matches = debug ? commandInterceptor instanceof CommandInvoker : commandInterceptor instanceof LoggingExecutionTreeCommandInvoker;
                if (matches) {
                    CommandInvoker commandInvoker;
                    CommandInvoker commandInvoker2 = commandInvoker = debug ? new LoggingExecutionTreeCommandInvoker() : new CommandInvoker();
                    if (previousCommandInterceptor != null) {
                        previousCommandInterceptor.setNext((CommandInterceptor)commandInvoker);
                    } else {
                        commandExecutorImpl.setFirst(previousCommandInterceptor);
                    }
                    break;
                }
                previousCommandInterceptor = commandInterceptor;
            }
        } else {
            pluggableActivitiTestCaseLogger.warn("Not using {}, ignoring the {} annotation", CommandExecutorImpl.class, EnableVerboseExecutionTreeLogging.class);
        }
    }
}

