/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import java.util.List;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.identitylink.service.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.task.service.impl.persistence.CountingTaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class IdentityLinkUtil {
    public static IdentityLinkEntity createProcessInstanceIdentityLink(ExecutionEntity processInstanceExecution, String userId, String groupId, String type) {
        IdentityLinkEntity identityLinkEntity = CommandContextUtil.getIdentityLinkService().createProcessInstanceIdentityLink(processInstanceExecution.getId(), userId, groupId, type);
        CommandContextUtil.getHistoryManager().recordIdentityLinkCreated(identityLinkEntity);
        processInstanceExecution.getIdentityLinks().add(identityLinkEntity);
        return identityLinkEntity;
    }

    public static void deleteTaskIdentityLinks(TaskEntity taskEntity, String userId, String groupId, String type) {
        List removedIdentityLinkEntities = CommandContextUtil.getIdentityLinkService().deleteTaskIdentityLink(taskEntity.getId(), taskEntity.getIdentityLinks(), userId, groupId, type);
        IdentityLinkUtil.handleTaskIdentityLinkDeletions(taskEntity, removedIdentityLinkEntities, true, true);
    }

    public static void deleteProcessInstanceIdentityLinks(ExecutionEntity processInstanceEntity, String userId, String groupId, String type) {
        List removedIdentityLinkEntities = CommandContextUtil.getIdentityLinkService().deleteProcessInstanceIdentityLink(processInstanceEntity.getId(), userId, groupId, type);
        for (IdentityLinkEntity identityLinkEntity : removedIdentityLinkEntities) {
            CommandContextUtil.getHistoryManager().recordIdentityLinkDeleted(identityLinkEntity);
        }
        processInstanceEntity.getIdentityLinks().removeAll(removedIdentityLinkEntities);
    }

    public static void handleTaskIdentityLinkAdditions(TaskEntity taskEntity, List<IdentityLinkEntity> identityLinkEntities) {
        for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
            IdentityLinkUtil.handleTaskIdentityLinkAddition(taskEntity, identityLinkEntity);
        }
    }

    public static void handleTaskIdentityLinkAddition(TaskEntity taskEntity, IdentityLinkEntity identityLinkEntity) {
        CountingTaskEntity countingTaskEntity;
        CommandContextUtil.getHistoryManager().recordIdentityLinkCreated(identityLinkEntity);
        if (CountingEntityUtil.isTaskRelatedEntityCountEnabledGlobally() && CountingEntityUtil.isTaskRelatedEntityCountEnabled(countingTaskEntity = (CountingTaskEntity)taskEntity)) {
            countingTaskEntity.setIdentityLinkCount(countingTaskEntity.getIdentityLinkCount() + 1);
        }
        taskEntity.getIdentityLinks().add(identityLinkEntity);
        if (identityLinkEntity.getUserId() != null && taskEntity.getProcessInstanceId() != null) {
            ExecutionEntity executionEntity = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(taskEntity.getProcessInstanceId());
            for (IdentityLinkEntity identityLink : executionEntity.getIdentityLinks()) {
                if (!identityLink.isUser() || !identityLink.getUserId().equals(identityLinkEntity.getUserId())) continue;
                return;
            }
            IdentityLinkUtil.createProcessInstanceIdentityLink(executionEntity, identityLinkEntity.getUserId(), null, "participant");
        }
    }

    public static void handleTaskIdentityLinkDeletions(TaskEntity taskEntity, List<IdentityLinkEntity> identityLinks, boolean cascadeHistory, boolean updateTaskCounts) {
        for (IdentityLinkEntity identityLinkEntity : identityLinks) {
            if (cascadeHistory) {
                CommandContextUtil.getHistoryManager().recordIdentityLinkDeleted(identityLinkEntity);
            }
            if (!updateTaskCounts) continue;
            IdentityLinkUtil.handleTaskCountsForIdentityLinkDeletion(taskEntity, identityLinkEntity);
        }
        taskEntity.getIdentityLinks().removeAll(identityLinks);
    }

    protected static void handleTaskCountsForIdentityLinkDeletion(TaskEntity taskEntity, IdentityLinkEntity identityLink) {
        CountingTaskEntity countingTaskEntity;
        if (CountingEntityUtil.isTaskRelatedEntityCountEnabledGlobally() && CountingEntityUtil.isTaskRelatedEntityCountEnabled(countingTaskEntity = (CountingTaskEntity)taskEntity)) {
            countingTaskEntity.setIdentityLinkCount(countingTaskEntity.getIdentityLinkCount() - 1);
        }
    }
}

