/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.ArrayList;
import java.util.List;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.GraphicInfo;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cmd.AbstractDynamicInjectionCmd;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.dynamic.BaseDynamicSubProcessInjectUtil;
import org.flowable.engine.impl.dynamic.DynamicUserTaskBuilder;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class InjectParallelUserTaskCmd
extends AbstractDynamicInjectionCmd
implements Command<Void> {
    protected String taskId;
    protected DynamicUserTaskBuilder dynamicUserTaskBuilder;

    public InjectParallelUserTaskCmd(String taskId, DynamicUserTaskBuilder dynamicUserTaskBuilder) {
        this.taskId = taskId;
        this.dynamicUserTaskBuilder = dynamicUserTaskBuilder;
    }

    public Void execute(CommandContext commandContext) {
        this.createDerivedProcessDefinitionForTask(commandContext, this.taskId);
        return null;
    }

    @Override
    protected void updateBpmnProcess(CommandContext commandContext, Process process, BpmnModel bpmnModel, ProcessDefinitionEntity originalProcessDefinitionEntity, DeploymentEntity newDeploymentEntity) {
        TaskEntity taskEntity = CommandContextUtil.getTaskService().getTask(this.taskId);
        FlowElement flowElement = process.getFlowElement(taskEntity.getTaskDefinitionKey(), true);
        if (!(flowElement instanceof UserTask)) {
            throw new FlowableException("No UserTask instance found for task definition key " + taskEntity.getTaskDefinitionKey());
        }
        UserTask userTask = (UserTask)flowElement;
        SubProcess subProcess = new SubProcess();
        String subProcessId = this.dynamicUserTaskBuilder.nextSubProcessId(process.getFlowElementMap());
        subProcess.setId(subProcessId);
        subProcess.setName(flowElement.getName());
        for (SequenceFlow incomingFlow : userTask.getIncomingFlows()) {
            incomingFlow.setTargetRef(subProcess.getId());
        }
        subProcess.setIncomingFlows(userTask.getIncomingFlows());
        for (SequenceFlow outgoingFlow : userTask.getOutgoingFlows()) {
            outgoingFlow.setSourceRef(subProcess.getId());
        }
        subProcess.setOutgoingFlows(userTask.getOutgoingFlows());
        userTask.setIncomingFlows(new ArrayList());
        userTask.setOutgoingFlows(new ArrayList());
        GraphicInfo elementGraphicInfo = bpmnModel.getGraphicInfo(flowElement.getId());
        if (elementGraphicInfo != null) {
            elementGraphicInfo.setExpanded(Boolean.valueOf(false));
            bpmnModel.addGraphicInfo(subProcess.getId(), elementGraphicInfo);
        }
        FlowElementsContainer parentContainer = userTask.getParentContainer();
        parentContainer.removeFlowElement(userTask.getId());
        bpmnModel.removeGraphicInfo(userTask.getId());
        subProcess.addFlowElement((FlowElement)userTask);
        parentContainer.addFlowElement((FlowElement)subProcess);
        StartEvent startEvent = new StartEvent();
        startEvent.setId(this.dynamicUserTaskBuilder.nextStartEventId(process.getFlowElementMap()));
        subProcess.addFlowElement((FlowElement)startEvent);
        ParallelGateway fork = new ParallelGateway();
        fork.setId(this.dynamicUserTaskBuilder.nextForkGatewayId(process.getFlowElementMap()));
        subProcess.addFlowElement((FlowElement)fork);
        SequenceFlow startFlow1 = new SequenceFlow(startEvent.getId(), fork.getId());
        startFlow1.setId(this.dynamicUserTaskBuilder.nextFlowId(process.getFlowElementMap()));
        subProcess.addFlowElement((FlowElement)startFlow1);
        UserTask newUserTask = new UserTask();
        if (this.dynamicUserTaskBuilder.getId() != null) {
            newUserTask.setId(this.dynamicUserTaskBuilder.getId());
        } else {
            newUserTask.setId(this.dynamicUserTaskBuilder.nextTaskId(process.getFlowElementMap()));
        }
        this.dynamicUserTaskBuilder.setDynamicTaskId(newUserTask.getId());
        newUserTask.setName(this.dynamicUserTaskBuilder.getName());
        newUserTask.setAssignee(this.dynamicUserTaskBuilder.getAssignee());
        subProcess.addFlowElement((FlowElement)newUserTask);
        SequenceFlow forkFlow1 = new SequenceFlow(fork.getId(), userTask.getId());
        forkFlow1.setId(this.dynamicUserTaskBuilder.nextFlowId(process.getFlowElementMap()));
        subProcess.addFlowElement((FlowElement)forkFlow1);
        SequenceFlow forkFlow2 = new SequenceFlow(fork.getId(), newUserTask.getId());
        forkFlow2.setId(this.dynamicUserTaskBuilder.nextFlowId(process.getFlowElementMap()));
        subProcess.addFlowElement((FlowElement)forkFlow2);
        EndEvent endEvent = new EndEvent();
        endEvent.setId(this.dynamicUserTaskBuilder.nextEndEventId(process.getFlowElementMap()));
        subProcess.addFlowElement((FlowElement)endEvent);
        ParallelGateway join = new ParallelGateway();
        join.setId(this.dynamicUserTaskBuilder.nextJoinGatewayId(process.getFlowElementMap()));
        subProcess.addFlowElement((FlowElement)join);
        SequenceFlow joinFlow1 = new SequenceFlow(userTask.getId(), join.getId());
        joinFlow1.setId(this.dynamicUserTaskBuilder.nextFlowId(process.getFlowElementMap()));
        subProcess.addFlowElement((FlowElement)joinFlow1);
        SequenceFlow joinFlow2 = new SequenceFlow(newUserTask.getId(), join.getId());
        joinFlow2.setId(this.dynamicUserTaskBuilder.nextFlowId(process.getFlowElementMap()));
        subProcess.addFlowElement((FlowElement)joinFlow2);
        SequenceFlow endFlow = new SequenceFlow(join.getId(), endEvent.getId());
        endFlow.setId(this.dynamicUserTaskBuilder.nextFlowId(process.getFlowElementMap()));
        subProcess.addFlowElement((FlowElement)endFlow);
        if (this.dynamicUserTaskBuilder.getDynamicUserTaskCallback() != null) {
            this.dynamicUserTaskBuilder.getDynamicUserTaskCallback().handleCreatedDynamicUserTask(newUserTask, subProcess, parentContainer, process);
        }
        if (elementGraphicInfo != null) {
            GraphicInfo startGraphicInfo = new GraphicInfo(45.0, 135.0, 30.0, 30.0);
            bpmnModel.addGraphicInfo(startEvent.getId(), startGraphicInfo);
            GraphicInfo forkGraphicInfo = new GraphicInfo(120.0, 130.0, 40.0, 40.0);
            bpmnModel.addGraphicInfo(fork.getId(), forkGraphicInfo);
            bpmnModel.addFlowGraphicInfoList(startFlow1.getId(), this.createWayPoints(75.0, 150.093, 120.375, 150.375));
            GraphicInfo taskGraphicInfo = new GraphicInfo(205.0, 30.0, 80.0, 100.0);
            bpmnModel.addGraphicInfo(userTask.getId(), taskGraphicInfo);
            bpmnModel.addFlowGraphicInfoList(forkFlow1.getId(), this.createWayPoints(140.5, 130.5, 140.5, 70.0, 205.0, 70.0));
            GraphicInfo newTaskGraphicInfo = new GraphicInfo(205.0, 195.0, 80.0, 100.0);
            bpmnModel.addGraphicInfo(newUserTask.getId(), newTaskGraphicInfo);
            bpmnModel.addFlowGraphicInfoList(forkFlow2.getId(), this.createWayPoints(140.5, 169.5, 140.5, 235.0, 205.0, 235.0));
            GraphicInfo joinGraphicInfo = new GraphicInfo(350.0, 130.0, 40.0, 40.0);
            bpmnModel.addGraphicInfo(join.getId(), joinGraphicInfo);
            bpmnModel.addFlowGraphicInfoList(joinFlow1.getId(), this.createWayPoints(305.0, 70.0, 370.0, 70.0, 370.0, 130.0));
            bpmnModel.addFlowGraphicInfoList(joinFlow2.getId(), this.createWayPoints(305.0, 235.0, 370.0, 235.0, 370.0, 169.5));
            GraphicInfo endGraphicInfo = new GraphicInfo(435.0, 136.0, 28.0, 28.0);
            bpmnModel.addGraphicInfo(endEvent.getId(), endGraphicInfo);
            bpmnModel.addFlowGraphicInfoList(endFlow.getId(), this.createWayPoints(389.621, 150.378, 435.0, 150.089));
        }
        BaseDynamicSubProcessInjectUtil.processFlowElements(commandContext, (FlowElementsContainer)process, bpmnModel, originalProcessDefinitionEntity, newDeploymentEntity);
    }

    @Override
    protected void updateExecutions(CommandContext commandContext, ProcessDefinitionEntity processDefinitionEntity, ExecutionEntity processInstance, List<ExecutionEntity> childExecutions) {
        TaskEntity taskEntity = CommandContextUtil.getTaskService().getTask(this.taskId);
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExecutionEntity executionAtTask = (ExecutionEntity)executionEntityManager.findById(taskEntity.getExecutionId());
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionEntity.getId());
        FlowElement taskElement = bpmnModel.getFlowElement(executionAtTask.getCurrentActivityId());
        FlowElement subProcessElement = bpmnModel.getFlowElement(((SubProcess)taskElement.getParentContainer()).getId());
        ExecutionEntity subProcessExecution = executionEntityManager.createChildExecution(executionAtTask.getParent());
        subProcessExecution.setScope(true);
        subProcessExecution.setCurrentFlowElement(subProcessElement);
        CommandContextUtil.getHistoryManager(commandContext).recordActivityStart(subProcessExecution);
        executionAtTask.setParent(subProcessExecution);
        ExecutionEntity taskExecution = executionEntityManager.createChildExecution(subProcessExecution);
        FlowElement userTaskElement = bpmnModel.getFlowElement(this.dynamicUserTaskBuilder.getDynamicTaskId());
        taskExecution.setCurrentFlowElement(userTaskElement);
        Context.getAgenda().planContinueProcessOperation(taskExecution);
    }
}

