/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.test;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.impl.history.HistoryLevel;
import org.flowable.common.engine.impl.test.EnsureCleanDb;
import org.flowable.engine.DynamicBpmnService;
import org.flowable.engine.FormService;
import org.flowable.engine.HistoryService;
import org.flowable.engine.IdentityService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.impl.ProcessEngineImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.DefaultHistoryManager;
import org.flowable.engine.impl.history.HistoryManager;
import org.flowable.engine.impl.test.AbstractTestCase;
import org.flowable.engine.impl.test.HistoryTestHelper;
import org.flowable.engine.impl.test.JobTestHelper;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.job.api.Job;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.junit.jupiter.api.BeforeEach;

@EnsureCleanDb(excludeTables={"ACT_GE_PROPERTY", "ACT_ID_PROPERTY"})
public abstract class AbstractFlowableTestCase
extends AbstractTestCase {
    protected ProcessEngine processEngine;
    protected static List<String> deploymentIdsForAutoCleanup = new ArrayList<String>();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected FormService formService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    protected DynamicBpmnService dynamicBpmnService;

    @BeforeEach
    public final void initializeServices(ProcessEngine processEngine) {
        this.processEngineConfiguration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        this.processEngine = processEngine;
        this.repositoryService = processEngine.getRepositoryService();
        this.runtimeService = processEngine.getRuntimeService();
        this.taskService = processEngine.getTaskService();
        this.formService = processEngine.getFormService();
        this.historyService = processEngine.getHistoryService();
        this.identityService = processEngine.getIdentityService();
        this.managementService = processEngine.getManagementService();
        this.dynamicBpmnService = processEngine.getDynamicBpmnService();
    }

    protected static void cleanDeployments(ProcessEngine processEngine) {
        ProcessEngineConfiguration processEngineConfiguration = processEngine.getProcessEngineConfiguration();
        for (String autoDeletedDeploymentId : deploymentIdsForAutoCleanup) {
            processEngineConfiguration.getRepositoryService().deleteDeployment(autoDeletedDeploymentId, true);
        }
        deploymentIdsForAutoCleanup.clear();
    }

    protected static void validateHistoryData(ProcessEngine processEngine) {
        ProcessEngineConfiguration processEngineConfiguration = processEngine.getProcessEngineConfiguration();
        HistoryService historyService = processEngine.getHistoryService();
        if (processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            List historicProcessInstances = historyService.createHistoricProcessInstanceQuery().finished().list();
            for (HistoricProcessInstance historicProcessInstance : historicProcessInstances) {
                List historicActivityInstances;
                AbstractFlowableTestCase.assertNotNull("Historic process instance has no process definition id", historicProcessInstance.getProcessDefinitionId());
                AbstractFlowableTestCase.assertNotNull("Historic process instance has no process definition key", historicProcessInstance.getProcessDefinitionKey());
                AbstractFlowableTestCase.assertNotNull("Historic process instance has no process definition version", historicProcessInstance.getProcessDefinitionVersion());
                AbstractFlowableTestCase.assertNotNull("Historic process instance has no deployment id", historicProcessInstance.getDeploymentId());
                AbstractFlowableTestCase.assertNotNull("Historic process instance has no start activity id", historicProcessInstance.getStartActivityId());
                AbstractFlowableTestCase.assertNotNull("Historic process instance has no start time", historicProcessInstance.getStartTime());
                AbstractFlowableTestCase.assertNotNull("Historic process instance has no end time", historicProcessInstance.getEndTime());
                String processInstanceId = historicProcessInstance.getId();
                List historicTaskInstances = ((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).list();
                if (historicTaskInstances != null && historicTaskInstances.size() > 0) {
                    for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
                        AbstractFlowableTestCase.assertEquals(processInstanceId, historicTaskInstance.getProcessInstanceId());
                        if (historicTaskInstance.getClaimTime() != null) {
                            AbstractFlowableTestCase.assertNotNull("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no work time", historicTaskInstance.getWorkTimeInMillis());
                        }
                        AbstractFlowableTestCase.assertNotNull("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no id", historicTaskInstance.getId());
                        AbstractFlowableTestCase.assertNotNull("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no process instance id", historicTaskInstance.getProcessInstanceId());
                        AbstractFlowableTestCase.assertNotNull("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no execution id", historicTaskInstance.getExecutionId());
                        AbstractFlowableTestCase.assertNotNull("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no process definition id", historicTaskInstance.getProcessDefinitionId());
                        AbstractFlowableTestCase.assertNotNull("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no task definition key", historicTaskInstance.getTaskDefinitionKey());
                        AbstractFlowableTestCase.assertNotNull("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no create time", historicTaskInstance.getCreateTime());
                        AbstractFlowableTestCase.assertNotNull("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no start time", historicTaskInstance.getStartTime());
                        AbstractFlowableTestCase.assertNotNull("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no end time", historicTaskInstance.getEndTime());
                    }
                }
                if ((historicActivityInstances = historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list()) == null || historicActivityInstances.size() <= 0) continue;
                for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                    AbstractFlowableTestCase.assertEquals(processInstanceId, historicActivityInstance.getProcessInstanceId());
                    AbstractFlowableTestCase.assertNotNull("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no activity id", historicActivityInstance.getActivityId());
                    AbstractFlowableTestCase.assertNotNull("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no activity type", historicActivityInstance.getActivityType());
                    AbstractFlowableTestCase.assertNotNull("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no process definition id", historicActivityInstance.getProcessDefinitionId());
                    AbstractFlowableTestCase.assertNotNull("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no process instance id", historicActivityInstance.getProcessInstanceId());
                    AbstractFlowableTestCase.assertNotNull("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no execution id", historicActivityInstance.getExecutionId());
                    AbstractFlowableTestCase.assertNotNull("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no start time", historicActivityInstance.getStartTime());
                    AbstractFlowableTestCase.assertNotNull("Historic activity instance " + historicActivityInstance.getId() + " / " + historicActivityInstance.getActivityId() + " has no end time", historicActivityInstance.getEndTime());
                }
            }
        }
    }

    public void assertProcessEnded(String processInstanceId) {
        this.assertProcessEnded(processInstanceId, 10000L);
    }

    public void assertProcessEnded(String processInstanceId, long timeout) {
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance != null) {
            throw new AssertionError((Object)("Expected finished process instance '" + processInstanceId + "' but it was still in the db"));
        }
        if (HistoryTestHelper.isHistoryLevelAtLeast(HistoryLevel.AUDIT, this.processEngineConfiguration, timeout)) {
            List historicActivityInstances;
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            AbstractFlowableTestCase.assertEquals(processInstanceId, historicProcessInstance.getId());
            AbstractFlowableTestCase.assertNotNull("Historic process instance has no start time", historicProcessInstance.getStartTime());
            AbstractFlowableTestCase.assertNotNull("Historic process instance has no end time", historicProcessInstance.getEndTime());
            List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).list();
            if (historicTaskInstances != null && historicTaskInstances.size() > 0) {
                for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
                    AbstractFlowableTestCase.assertEquals(processInstanceId, historicTaskInstance.getProcessInstanceId());
                    AbstractFlowableTestCase.assertNotNull("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no start time", historicTaskInstance.getStartTime());
                    AbstractFlowableTestCase.assertNotNull("Historic task " + historicTaskInstance.getTaskDefinitionKey() + " has no end time", historicTaskInstance.getEndTime());
                }
            }
            if ((historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list()) != null && historicActivityInstances.size() > 0) {
                for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                    AbstractFlowableTestCase.assertEquals(processInstanceId, historicActivityInstance.getProcessInstanceId());
                    AbstractFlowableTestCase.assertNotNull(historicActivityInstance.getId() + " Historic activity instance '" + historicActivityInstance.getActivityId() + "' has no start time", historicActivityInstance.getStartTime());
                    AbstractFlowableTestCase.assertNotNull(historicActivityInstance.getId() + " Historic activity instance '" + historicActivityInstance.getActivityId() + "' has no end time", historicActivityInstance.getEndTime());
                }
            }
        }
    }

    public void waitForJobExecutorToProcessAllJobs(long maxMillisToWait, long intervalMillis) {
        JobTestHelper.waitForJobExecutorToProcessAllJobs(this.processEngineConfiguration, this.managementService, maxMillisToWait, intervalMillis);
    }

    public void waitForJobExecutorOnCondition(long maxMillisToWait, long intervalMillis, Callable<Boolean> condition) {
        JobTestHelper.waitForJobExecutorOnCondition(this.processEngineConfiguration, maxMillisToWait, intervalMillis, condition);
    }

    public void executeJobExecutorForTime(long maxMillisToWait, long intervalMillis) {
        JobTestHelper.executeJobExecutorForTime(this.processEngineConfiguration, maxMillisToWait, intervalMillis);
    }

    public void waitForJobExecutorToProcessAllJobsAndExecutableTimerJobs(long maxMillisToWait, long intervalMillis) {
        JobTestHelper.waitForJobExecutorToProcessAllJobsAndExecutableTimerJobs(this.processEngineConfiguration, this.managementService, maxMillisToWait, intervalMillis);
    }

    public void waitForJobExecutorToProcessAllHistoryJobs(long maxMillisToWait, long intervalMillis) {
        HistoryTestHelper.waitForJobExecutorToProcessAllHistoryJobs(this.processEngineConfiguration, this.managementService, maxMillisToWait, intervalMillis);
    }

    public void waitForHistoryJobExecutorToProcessAllJobs(long maxMillisToWait, long intervalMillis) {
        HistoryTestHelper.waitForJobExecutorToProcessAllHistoryJobs(this.processEngineConfiguration, this.managementService, maxMillisToWait, intervalMillis);
    }

    public BpmnModel createOneTaskTestProcess() {
        BpmnModel model = new BpmnModel();
        Process process = new Process();
        model.addProcess(process);
        process.setId("oneTaskProcess");
        process.setName("The one task process");
        StartEvent startEvent = new StartEvent();
        startEvent.setId("start");
        startEvent.setName("The start");
        process.addFlowElement((FlowElement)startEvent);
        UserTask userTask = new UserTask();
        userTask.setName("The Task");
        userTask.setId("theTask");
        userTask.setAssignee("kermit");
        process.addFlowElement((FlowElement)userTask);
        EndEvent endEvent = new EndEvent();
        endEvent.setId("theEnd");
        endEvent.setName("The end");
        process.addFlowElement((FlowElement)endEvent);
        process.addFlowElement((FlowElement)new SequenceFlow("start", "theTask"));
        process.addFlowElement((FlowElement)new SequenceFlow("theTask", "theEnd"));
        return model;
    }

    public BpmnModel createTwoTasksTestProcess() {
        BpmnModel model = new BpmnModel();
        Process process = new Process();
        model.addProcess(process);
        process.setId("twoTasksProcess");
        process.setName("The two tasks process");
        StartEvent startEvent = new StartEvent();
        startEvent.setId("start");
        process.addFlowElement((FlowElement)startEvent);
        UserTask userTask = new UserTask();
        userTask.setName("The First Task");
        userTask.setId("task1");
        userTask.setAssignee("kermit");
        process.addFlowElement((FlowElement)userTask);
        UserTask userTask2 = new UserTask();
        userTask2.setName("The Second Task");
        userTask2.setId("task2");
        userTask2.setAssignee("kermit");
        process.addFlowElement((FlowElement)userTask2);
        EndEvent endEvent = new EndEvent();
        endEvent.setId("theEnd");
        process.addFlowElement((FlowElement)endEvent);
        process.addFlowElement((FlowElement)new SequenceFlow("start", "task1"));
        process.addFlowElement((FlowElement)new SequenceFlow("start", "task2"));
        process.addFlowElement((FlowElement)new SequenceFlow("task1", "theEnd"));
        process.addFlowElement((FlowElement)new SequenceFlow("task2", "theEnd"));
        return model;
    }

    public String deployOneTaskTestProcess() {
        BpmnModel bpmnModel = this.createOneTaskTestProcess();
        Deployment deployment = this.repositoryService.createDeployment().addBpmnModel("oneTasktest.bpmn20.xml", bpmnModel).deploy();
        deploymentIdsForAutoCleanup.add(deployment.getId());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        return processDefinition.getId();
    }

    public String deployTwoTasksTestProcess() {
        BpmnModel bpmnModel = this.createTwoTasksTestProcess();
        Deployment deployment = this.repositoryService.createDeployment().addBpmnModel("twoTasksTestProcess.bpmn20.xml", bpmnModel).deploy();
        deploymentIdsForAutoCleanup.add(deployment.getId());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        return processDefinition.getId();
    }

    protected void deleteDeployments() {
        boolean isAsyncHistoryEnabled = this.processEngineConfiguration.isAsyncHistoryEnabled();
        HistoryManager asyncHistoryManager = null;
        if (isAsyncHistoryEnabled) {
            this.processEngineConfiguration.setAsyncHistoryEnabled(false);
            asyncHistoryManager = this.processEngineConfiguration.getHistoryManager();
            this.processEngineConfiguration.setHistoryManager(new DefaultHistoryManager(this.processEngineConfiguration, this.processEngineConfiguration.getHistoryLevel(), this.processEngineConfiguration.isUsePrefixId()));
        }
        for (Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
        if (isAsyncHistoryEnabled) {
            this.processEngineConfiguration.setAsyncHistoryEnabled(true);
            this.processEngineConfiguration.setHistoryManager(asyncHistoryManager);
        }
    }

    protected void deleteDeployment(String deploymentId) {
        boolean isAsyncHistoryEnabled = this.processEngineConfiguration.isAsyncHistoryEnabled();
        HistoryManager asyncHistoryManager = null;
        if (isAsyncHistoryEnabled) {
            this.processEngineConfiguration.setAsyncHistoryEnabled(false);
            asyncHistoryManager = this.processEngineConfiguration.getHistoryManager();
            this.processEngineConfiguration.setHistoryManager(new DefaultHistoryManager(this.processEngineConfiguration, this.processEngineConfiguration.getHistoryLevel(), this.processEngineConfiguration.isUsePrefixId()));
        }
        this.repositoryService.deleteDeployment(deploymentId, true);
        if (isAsyncHistoryEnabled) {
            this.processEngineConfiguration.setAsyncHistoryEnabled(true);
            this.processEngineConfiguration.setHistoryManager(asyncHistoryManager);
        }
    }

    protected void assertHistoricTasksDeleteReason(ProcessInstance processInstance, String expectedDeleteReason, String ... taskNames) {
        if (this.processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            for (String taskName : taskNames) {
                List historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getId())).taskName(taskName)).list();
                AbstractFlowableTestCase.assertTrue(historicTaskInstances.size() > 0);
                for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
                    AbstractFlowableTestCase.assertNotNull(historicTaskInstance.getEndTime());
                    if (expectedDeleteReason == null) {
                        AbstractFlowableTestCase.assertNull(historicTaskInstance.getDeleteReason());
                        continue;
                    }
                    AbstractFlowableTestCase.assertTrue(historicTaskInstance.getDeleteReason().startsWith(expectedDeleteReason));
                }
            }
        }
    }

    protected void assertHistoricActivitiesDeleteReason(ProcessInstance processInstance, String expectedDeleteReason, String ... activityIds) {
        if (this.processEngineConfiguration.getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
            for (String activityId : activityIds) {
                List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().activityId(activityId).processInstanceId(processInstance.getId()).list();
                AbstractFlowableTestCase.assertTrue("Could not find historic activities", historicActivityInstances.size() > 0);
                for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                    AbstractFlowableTestCase.assertNotNull(historicActivityInstance.getEndTime());
                    if (expectedDeleteReason == null) {
                        AbstractFlowableTestCase.assertNull(historicActivityInstance.getDeleteReason());
                        continue;
                    }
                    AbstractFlowableTestCase.assertTrue(historicActivityInstance.getDeleteReason().startsWith(expectedDeleteReason));
                }
            }
        }
    }

    protected void completeTask(Task task) {
        this.taskService.complete(task.getId());
    }

    protected static <T> List<T> mergeLists(List<T> list1, List<T> list2) {
        Objects.requireNonNull(list1);
        Objects.requireNonNull(list2);
        return Stream.concat(list1.stream(), list2.stream()).collect(Collectors.toList());
    }

    protected static <T> Map<String, List<T>> groupListContentBy(List<T> source, Function<T, String> classifier) {
        return source.stream().collect(Collectors.groupingBy(classifier));
    }

    protected String getJobActivityId(Job job) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            Map jobConfigurationMap = (Map)objectMapper.readValue(job.getJobHandlerConfiguration(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            return (String)jobConfigurationMap.get("activityId");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected ProcessDefinition deployProcessDefinition(String name, String path) {
        Deployment deployment = this.repositoryService.createDeployment().name(name).addClasspathResource(path).deploy();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
        return processDefinition;
    }

    protected void completeProcessInstanceTasks(String processInstanceId) {
        List tasks;
        do {
            tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
            tasks.forEach(this::completeTask);
        } while (!tasks.isEmpty());
    }
}

