/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.Signal;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.bpmn.model.ValuedDataObject;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.callback.CallbackData;
import org.flowable.common.engine.impl.callback.RuntimeInstanceStateChangeCallback;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.jobexecutor.TimerEventHandler;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.flowable.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.util.TimerUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;

public class ProcessInstanceHelper {
    public ProcessInstance createProcessInstance(ProcessDefinition processDefinition, String businessKey, String processInstanceName, Map<String, Object> variables, Map<String, Object> transientVariables) {
        return this.createProcessInstance(processDefinition, businessKey, processInstanceName, null, variables, transientVariables, null, null, false);
    }

    public ProcessInstance createAndStartProcessInstance(ProcessDefinition processDefinition, String businessKey, String processInstanceName, Map<String, Object> variables, Map<String, Object> transientVariables) {
        return this.createProcessInstance(processDefinition, businessKey, processInstanceName, null, variables, transientVariables, null, null, true);
    }

    public ProcessInstance createProcessInstance(ProcessDefinition processDefinition, String businessKey, String processInstanceName, String overrideDefinitionTenantId, Map<String, Object> variables, Map<String, Object> transientVariables, String callbackId, String callbackType, boolean startProcessInstance) {
        CommandContext commandContext = Context.getCommandContext();
        if (Flowable5Util.isFlowable5ProcessDefinition(processDefinition, commandContext)) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            return compatibilityHandler.startProcessInstance(processDefinition.getKey(), processDefinition.getId(), variables, transientVariables, businessKey, processDefinition.getTenantId(), processInstanceName);
        }
        if (ProcessDefinitionUtil.isProcessDefinitionSuspended(processDefinition.getId())) {
            throw new FlowableException("Cannot start process instance. Process definition " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") is suspended");
        }
        Process process = ProcessDefinitionUtil.getProcess(processDefinition.getId());
        if (process == null) {
            throw new FlowableException("Cannot start process instance. Process model " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") could not be found");
        }
        FlowElement initialFlowElement = process.getInitialFlowElement();
        if (initialFlowElement == null) {
            throw new FlowableException("No start element found for process definition " + processDefinition.getId());
        }
        return this.createAndStartProcessInstanceWithInitialFlowElement(processDefinition, businessKey, processInstanceName, overrideDefinitionTenantId, initialFlowElement, process, variables, transientVariables, callbackId, callbackType, startProcessInstance);
    }

    public ProcessInstance createAndStartProcessInstanceByMessage(ProcessDefinition processDefinition, String messageName, String businessKey, Map<String, Object> variables, Map<String, Object> transientVariables, String callbackId, String callbackType) {
        CommandContext commandContext = Context.getCommandContext();
        if (Flowable5Util.isFlowable5ProcessDefinition(processDefinition, commandContext)) {
            return CommandContextUtil.getProcessEngineConfiguration(commandContext).getFlowable5CompatibilityHandler().startProcessInstanceByMessage(messageName, variables, transientVariables, businessKey, processDefinition.getTenantId());
        }
        if (ProcessDefinitionUtil.isProcessDefinitionSuspended(processDefinition.getId())) {
            throw new FlowableException("Cannot start process instance. Process definition " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") is suspended");
        }
        Process process = ProcessDefinitionUtil.getProcess(processDefinition.getId());
        if (process == null) {
            throw new FlowableException("Cannot start process instance. Process model " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") could not be found");
        }
        FlowElement initialFlowElement = null;
        for (FlowElement flowElement : process.getFlowElements()) {
            MessageEventDefinition messageEventDefinition;
            StartEvent startEvent;
            if (!(flowElement instanceof StartEvent) || !CollectionUtil.isNotEmpty((Collection)(startEvent = (StartEvent)flowElement).getEventDefinitions()) || !(startEvent.getEventDefinitions().get(0) instanceof MessageEventDefinition) || !(messageEventDefinition = (MessageEventDefinition)startEvent.getEventDefinitions().get(0)).getMessageRef().equals(messageName)) continue;
            initialFlowElement = flowElement;
            break;
        }
        if (initialFlowElement == null) {
            throw new FlowableException("No message start event found for process definition " + processDefinition.getId() + " and message name " + messageName);
        }
        return this.createAndStartProcessInstanceWithInitialFlowElement(processDefinition, businessKey, null, null, initialFlowElement, process, variables, transientVariables, callbackId, callbackType, true);
    }

    public ProcessInstance createAndStartProcessInstanceWithInitialFlowElement(ProcessDefinition processDefinition, String businessKey, String processInstanceName, FlowElement initialFlowElement, Process process, Map<String, Object> variables, Map<String, Object> transientVariables, boolean startProcessInstance) {
        return this.createAndStartProcessInstanceWithInitialFlowElement(processDefinition, businessKey, processInstanceName, null, initialFlowElement, process, variables, transientVariables, null, null, startProcessInstance);
    }

    public ProcessInstance createAndStartProcessInstanceWithInitialFlowElement(ProcessDefinition processDefinition, String businessKey, String processInstanceName, String overrideDefinitionTenantId, FlowElement initialFlowElement, Process process, Map<String, Object> variables, Map<String, Object> transientVariables, String callbackId, String callbackType, boolean startProcessInstance) {
        CommandContext commandContext = Context.getCommandContext();
        String initiatorVariableName = null;
        if (initialFlowElement instanceof StartEvent) {
            initiatorVariableName = ((StartEvent)initialFlowElement).getInitiator();
        }
        String tenantId = null;
        tenantId = overrideDefinitionTenantId != null ? overrideDefinitionTenantId : processDefinition.getTenantId();
        ExecutionEntity processInstance = CommandContextUtil.getExecutionEntityManager(commandContext).createProcessInstanceExecution(processDefinition, businessKey, tenantId, initiatorVariableName, initialFlowElement.getId());
        processInstance.setName(processInstanceName);
        if (callbackId != null) {
            processInstance.setCallbackId(callbackId);
        }
        if (callbackType != null) {
            processInstance.setCallbackType(callbackType);
        }
        CommandContextUtil.getHistoryManager(commandContext).recordProcessInstanceStart(processInstance);
        boolean eventDispatcherEnabled = CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().isEnabled();
        if (eventDispatcherEnabled) {
            CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.PROCESS_CREATED, processInstance));
        }
        processInstance.setVariables(this.processDataObjects(process.getDataObjects()));
        if (variables != null) {
            for (String varName : variables.keySet()) {
                processInstance.setVariable(varName, variables.get(varName));
            }
        }
        if (transientVariables != null) {
            for (String varName : transientVariables.keySet()) {
                processInstance.setTransientVariable(varName, transientVariables.get(varName));
            }
        }
        if (eventDispatcherEnabled) {
            CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityWithVariablesEvent(FlowableEngineEventType.ENTITY_INITIALIZED, processInstance, variables, false));
        }
        ExecutionEntity execution = CommandContextUtil.getExecutionEntityManager(commandContext).createChildExecution(processInstance);
        execution.setCurrentFlowElement(initialFlowElement);
        if (startProcessInstance) {
            this.startProcessInstance(processInstance, commandContext, variables);
        }
        if (callbackId != null) {
            this.callCaseInstanceStateChangeCallbacks(commandContext, processInstance, null, "running");
        }
        return processInstance;
    }

    public void startProcessInstance(ExecutionEntity processInstance, CommandContext commandContext, Map<String, Object> variables) {
        Process process = ProcessDefinitionUtil.getProcess(processInstance.getProcessDefinitionId());
        this.processAvailableEventSubProcesses(processInstance, (FlowElementsContainer)process, commandContext);
        ExecutionEntity execution = processInstance.getExecutions().get(0);
        CommandContextUtil.getAgenda(commandContext).planContinueProcessOperation(execution);
        if (CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            FlowableEventDispatcher eventDispatcher = CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher();
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createProcessStartedEvent(execution, variables, false));
        }
    }

    public void processAvailableEventSubProcesses(ExecutionEntity parentExecution, FlowElementsContainer parentContainer, CommandContext commandContext) {
        for (FlowElement flowElement : parentContainer.getFlowElements()) {
            if (!(flowElement instanceof EventSubProcess)) continue;
            this.processEventSubProcess(parentExecution, (EventSubProcess)flowElement, commandContext);
        }
    }

    public void processEventSubProcess(ExecutionEntity parentExecution, EventSubProcess eventSubProcess, CommandContext commandContext) {
        LinkedList<MessageEventSubscriptionEntity> messageEventSubscriptions = new LinkedList<MessageEventSubscriptionEntity>();
        LinkedList<SignalEventSubscriptionEntity> signalEventSubscriptions = new LinkedList<SignalEventSubscriptionEntity>();
        for (FlowElement subElement : eventSubProcess.getFlowElements()) {
            BpmnModel bpmnModel;
            StartEvent startEvent;
            if (!(subElement instanceof StartEvent) || CollectionUtil.isEmpty((Collection)(startEvent = (StartEvent)subElement).getEventDefinitions())) continue;
            EventDefinition eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0);
            if (eventDefinition instanceof MessageEventDefinition) {
                MessageEventDefinition messageEventDefinition = (MessageEventDefinition)eventDefinition;
                bpmnModel = ProcessDefinitionUtil.getBpmnModel(parentExecution.getProcessDefinitionId());
                if (bpmnModel.containsMessageId(messageEventDefinition.getMessageRef())) {
                    messageEventDefinition.setMessageRef(bpmnModel.getMessage(messageEventDefinition.getMessageRef()).getName());
                }
                ExecutionEntity messageExecution = CommandContextUtil.getExecutionEntityManager(commandContext).createChildExecution(parentExecution);
                messageExecution.setCurrentFlowElement((FlowElement)startEvent);
                messageExecution.setEventScope(true);
                messageExecution.setActive(false);
                messageEventSubscriptions.add(CommandContextUtil.getEventSubscriptionEntityManager(commandContext).insertMessageEvent(messageEventDefinition.getMessageRef(), messageExecution));
                continue;
            }
            if (eventDefinition instanceof SignalEventDefinition) {
                SignalEventDefinition signalEventDefinition = (SignalEventDefinition)eventDefinition;
                bpmnModel = ProcessDefinitionUtil.getBpmnModel(parentExecution.getProcessDefinitionId());
                Signal signal = null;
                if (bpmnModel.containsSignalId(signalEventDefinition.getSignalRef())) {
                    signal = bpmnModel.getSignal(signalEventDefinition.getSignalRef());
                    signalEventDefinition.setSignalRef(signal.getName());
                }
                ExecutionEntity signalExecution = CommandContextUtil.getExecutionEntityManager(commandContext).createChildExecution(parentExecution);
                signalExecution.setCurrentFlowElement((FlowElement)startEvent);
                signalExecution.setEventScope(true);
                signalExecution.setActive(false);
                signalEventSubscriptions.add(CommandContextUtil.getEventSubscriptionEntityManager(commandContext).insertSignalEvent(signalEventDefinition.getSignalRef(), signal, signalExecution));
                continue;
            }
            if (!(eventDefinition instanceof TimerEventDefinition)) continue;
            TimerEventDefinition timerEventDefinition = (TimerEventDefinition)eventDefinition;
            ExecutionEntity timerExecution = CommandContextUtil.getExecutionEntityManager(commandContext).createChildExecution(parentExecution);
            timerExecution.setCurrentFlowElement((FlowElement)startEvent);
            timerExecution.setEventScope(true);
            timerExecution.setActive(false);
            TimerJobEntity timerJob = TimerUtil.createTimerEntityForTimerEventDefinition(timerEventDefinition, false, timerExecution, "trigger-timer", TimerEventHandler.createConfiguration(startEvent.getId(), timerEventDefinition.getEndDate(), timerEventDefinition.getCalendarName()));
            if (timerJob == null) continue;
            CommandContextUtil.getTimerJobService().scheduleTimerJob(timerJob);
        }
        if (CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            for (MessageEventSubscriptionEntity messageEventSubscription : messageEventSubscriptions) {
                CommandContextUtil.getProcessEngineConfiguration(commandContext).getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createMessageEvent(FlowableEngineEventType.ACTIVITY_MESSAGE_WAITING, messageEventSubscription.getActivityId(), messageEventSubscription.getEventName(), null, messageEventSubscription.getExecution().getId(), messageEventSubscription.getProcessInstanceId(), messageEventSubscription.getProcessDefinitionId()));
            }
            for (SignalEventSubscriptionEntity signalEventSubscription : signalEventSubscriptions) {
                CommandContextUtil.getProcessEngineConfiguration(commandContext).getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createSignalEvent(FlowableEngineEventType.ACTIVITY_SIGNAL_WAITING, signalEventSubscription.getActivityId(), signalEventSubscription.getEventName(), null, signalEventSubscription.getExecution().getId(), signalEventSubscription.getProcessInstanceId(), signalEventSubscription.getProcessDefinitionId()));
            }
        }
    }

    protected Map<String, Object> processDataObjects(Collection<ValuedDataObject> dataObjects) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }

    public void callCaseInstanceStateChangeCallbacks(CommandContext commandContext, ProcessInstance processInstance, String oldState, String newState) {
        Map<String, List<RuntimeInstanceStateChangeCallback>> caseInstanceCallbacks;
        if (processInstance.getCallbackId() != null && processInstance.getCallbackType() != null && (caseInstanceCallbacks = CommandContextUtil.getProcessEngineConfiguration(commandContext).getProcessInstanceStateChangedCallbacks()) != null && caseInstanceCallbacks.containsKey(processInstance.getCallbackType())) {
            for (RuntimeInstanceStateChangeCallback caseInstanceCallback : caseInstanceCallbacks.get(processInstance.getCallbackType())) {
                caseInstanceCallback.stateChanged(new CallbackData(processInstance.getCallbackId(), processInstance.getCallbackType(), processInstance.getId(), oldState, newState));
            }
        }
    }
}

