/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.jobexecutor;

import java.util.Collection;
import java.util.Objects;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.SendEventServiceTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.EventInstanceBpmnUtil;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;
import org.flowable.eventregistry.impl.runtime.EventInstanceImpl;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class AsyncSendEventJobHandler
implements JobHandler {
    public static final String TYPE = "async-send-event";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        ExecutionEntity executionEntity = (ExecutionEntity)variableScope;
        FlowElement flowElement = executionEntity.getCurrentFlowElement();
        if (!(flowElement instanceof SendEventServiceTask)) {
            throw new FlowableException(String.format("unexpected activity type found for job %s, at activity %s", job.getId(), flowElement.getId()));
        }
        SendEventServiceTask sendEventServiceTask = (SendEventServiceTask)flowElement;
        EventModel eventModel = null;
        eventModel = Objects.equals("", job.getTenantId()) ? CommandContextUtil.getEventRepositoryService(commandContext).getEventModelByKey(sendEventServiceTask.getEventType()) : CommandContextUtil.getEventRepositoryService(commandContext).getEventModelByKey(sendEventServiceTask.getEventType(), job.getTenantId());
        if (eventModel == null) {
            throw new FlowableException("No event model found for event key " + sendEventServiceTask.getEventType());
        }
        EventInstanceImpl eventInstance = new EventInstanceImpl();
        eventInstance.setEventModel(eventModel);
        Collection<EventPayloadInstance> eventPayloadInstances = EventInstanceBpmnUtil.createEventPayloadInstances(executionEntity, CommandContextUtil.getProcessEngineConfiguration().getExpressionManager(), (BaseElement)sendEventServiceTask, eventModel);
        eventInstance.setPayloadInstances(eventPayloadInstances);
        CommandContextUtil.getEventRegistry(commandContext).sendEventOutbound((EventInstance)eventInstance);
        if (!sendEventServiceTask.isTriggerable()) {
            CommandContextUtil.getAgenda(commandContext).planTakeOutgoingSequenceFlowsOperation(executionEntity, true);
        }
    }
}

