/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.db;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableWrongDbException;
import org.flowable.common.engine.impl.FlowableVersions;
import org.flowable.common.engine.impl.db.AbstractSqlScriptBasedDbSchemaManager;
import org.flowable.common.engine.impl.db.DbSqlSession;
import org.flowable.common.engine.impl.db.SchemaManager;
import org.flowable.common.engine.impl.lock.LockManager;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.persistence.entity.PropertyEntity;
import org.flowable.common.engine.impl.persistence.entity.PropertyEntityImpl;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;

public class ProcessDbSchemaManager
extends AbstractSqlScriptBasedDbSchemaManager {
    protected static final Pattern CLEAN_VERSION_REGEX = Pattern.compile("\\d\\.\\d*");
    protected static final String PROCESS_DB_SCHEMA_LOCK_NAME = "processDbSchemaLock";

    public void schemaCheckVersion() {
        try {
            String dbVersion = this.getDbVersion();
            if (!"6.7.1.0".equals(dbVersion)) {
                throw new FlowableWrongDbException("6.7.1.0", dbVersion);
            }
            String errorMessage = null;
            if (!this.isEngineTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "engine");
            }
            if (CommandContextUtil.getDbSqlSession().getDbSqlSessionFactory().isDbHistoryUsed() && !this.isHistoryTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "history");
            }
            if (errorMessage != null) {
                throw new FlowableException("Flowable database problem: " + errorMessage);
            }
        }
        catch (Exception e) {
            if (this.isMissingTablesException(e)) {
                throw new FlowableException("no flowable tables in db. set <property name=\"databaseSchemaUpdate\" to value=\"true\" or value=\"create-drop\" (use create-drop for testing only!) in bean processEngineConfiguration in flowable.cfg.xml for automatic schema creation", (Throwable)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new FlowableException("couldn't get db schema version", (Throwable)e);
        }
        this.logger.debug("flowable db schema check successful");
    }

    protected String addMissingComponent(String missingComponents, String component) {
        if (missingComponents == null) {
            return "Tables missing for component(s) " + component;
        }
        return missingComponents + ", " + component;
    }

    protected String getDbVersion() {
        DbSqlSession dbSqlSession = CommandContextUtil.getDbSqlSession();
        String selectSchemaVersionStatement = dbSqlSession.getDbSqlSessionFactory().mapStatement("org.flowable.common.engine.impl.persistence.entity.PropertyEntityImpl.selectDbSchemaVersion");
        return (String)dbSqlSession.getSqlSession().selectOne(selectSchemaVersionStatement);
    }

    public void schemaCreate() {
        this.getCommonSchemaManager().schemaCreate();
        ProcessEngineConfigurationImpl processEngineConfiguration = this.getProcessEngineConfiguration();
        if (processEngineConfiguration.isUseLockForDatabaseSchemaUpdate()) {
            LockManager lockManager = processEngineConfiguration.getManagementService().getLockManager(PROCESS_DB_SCHEMA_LOCK_NAME);
            lockManager.waitForLockRunAndRelease(processEngineConfiguration.getSchemaLockWaitTime(), () -> {
                this.schemaCreateInLock();
                return null;
            });
        } else {
            this.schemaCreateInLock();
        }
    }

    protected void schemaCreateInLock() {
        this.getIdentityLinkSchemaManager().schemaCreate();
        this.getEntityLinkSchemaManager().schemaCreate();
        this.getEventSubscriptionSchemaManager().schemaCreate();
        this.getTaskSchemaManager().schemaCreate();
        this.getVariableSchemaManager().schemaCreate();
        this.getJobSchemaManager().schemaCreate();
        this.getBatchSchemaManager().schemaCreate();
        if (this.isEngineTablePresent()) {
            String dbVersion = this.getDbVersion();
            if (!"6.7.1.0".equals(dbVersion)) {
                throw new FlowableWrongDbException("6.7.1.0", dbVersion);
            }
        } else {
            this.dbSchemaCreateEngine();
        }
        if (CommandContextUtil.getDbSqlSession().getDbSqlSessionFactory().isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
    }

    protected void dbSchemaCreateHistory() {
        this.executeMandatorySchemaResource("create", "history");
    }

    protected void dbSchemaCreateEngine() {
        this.executeMandatorySchemaResource("create", "engine");
    }

    public void schemaDrop() {
        try {
            this.executeMandatorySchemaResource("drop", "engine");
            if (CommandContextUtil.getDbSqlSession().getDbSqlSessionFactory().isDbHistoryUsed()) {
                this.executeMandatorySchemaResource("drop", "history");
            }
        }
        catch (Exception e) {
            this.logger.info("Error dropping engine tables", (Throwable)e);
        }
        try {
            this.getBatchSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping batch tables", (Throwable)e);
        }
        try {
            this.getJobSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping job tables", (Throwable)e);
        }
        try {
            this.getVariableSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping variable tables", (Throwable)e);
        }
        try {
            this.getTaskSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping task tables", (Throwable)e);
        }
        try {
            this.getEventSubscriptionSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping event subscription tables", (Throwable)e);
        }
        try {
            this.getEntityLinkSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping entity link tables", (Throwable)e);
        }
        try {
            this.getIdentityLinkSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping identity link tables", (Throwable)e);
        }
        try {
            this.getCommonSchemaManager().schemaDrop();
        }
        catch (Exception e) {
            this.logger.info("Error dropping common tables", (Throwable)e);
        }
    }

    public void dbSchemaPrune() {
        if (this.isHistoryTablePresent() && !CommandContextUtil.getDbSqlSession().getDbSqlSessionFactory().isDbHistoryUsed()) {
            this.executeMandatorySchemaResource("drop", "history");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String schemaUpdate() {
        LockManager lockManager;
        PropertyEntity dbVersionProperty = null;
        String dbVersion = null;
        String feedback = null;
        boolean isUpgradeNeeded = false;
        int matchingVersionIndex = -1;
        int version6120Index = FlowableVersions.getFlowableVersionIndexForDbVersion((String)"6.1.2.0");
        this.getCommonSchemaManager().schemaUpdate();
        ProcessEngineConfigurationImpl processEngineConfiguration = this.getProcessEngineConfiguration();
        if (processEngineConfiguration.isUseLockForDatabaseSchemaUpdate()) {
            lockManager = processEngineConfiguration.getManagementService().getLockManager(PROCESS_DB_SCHEMA_LOCK_NAME);
            lockManager.waitForLock(processEngineConfiguration.getSchemaLockWaitTime());
        } else {
            lockManager = null;
        }
        try {
            DbSqlSession dbSqlSession = CommandContextUtil.getDbSqlSession();
            boolean isEngineTablePresent = this.isEngineTablePresent();
            if (isEngineTablePresent) {
                dbVersionProperty = (PropertyEntity)dbSqlSession.selectById(PropertyEntityImpl.class, "schema.version");
                dbVersion = dbVersionProperty.getValue();
                matchingVersionIndex = FlowableVersions.getFlowableVersionIndexForDbVersion((String)dbVersion);
                isUpgradeNeeded = matchingVersionIndex != FlowableVersions.FLOWABLE_VERSIONS.size() - 1;
            }
            boolean isHistoryTablePresent = this.isHistoryTablePresent();
            if (isUpgradeNeeded && matchingVersionIndex < version6120Index) {
                this.dbSchemaUpgradeUntil6120("engine", matchingVersionIndex);
                if (isHistoryTablePresent) {
                    this.dbSchemaUpgradeUntil6120("history", matchingVersionIndex);
                }
            }
            this.getIdentityLinkSchemaManager().schemaUpdate();
            this.getEntityLinkSchemaManager().schemaUpdate();
            this.getEventSubscriptionSchemaManager().schemaUpdate();
            this.getTaskSchemaManager().schemaUpdate();
            this.getVariableSchemaManager().schemaUpdate();
            this.getJobSchemaManager().schemaUpdate();
            this.getBatchSchemaManager().schemaUpdate();
            if (isUpgradeNeeded) {
                PropertyEntity dbHistoryProperty;
                dbVersionProperty.setValue("6.7.1.0");
                if ("5.0".equals(dbVersion)) {
                    dbHistoryProperty = (PropertyEntity)CommandContextUtil.getPropertyEntityManager().create();
                    dbHistoryProperty.setName("schema.history");
                    dbHistoryProperty.setValue("create(5.0)");
                    dbSqlSession.insert((Entity)dbHistoryProperty, processEngineConfiguration.getIdGenerator());
                } else {
                    dbHistoryProperty = (PropertyEntity)dbSqlSession.selectById(PropertyEntity.class, "schema.history");
                }
                String dbHistoryValue = "upgrade(" + dbVersion + "->" + "6.7.1.0" + ")";
                dbHistoryProperty.setValue(dbHistoryValue);
                if (version6120Index > matchingVersionIndex) {
                    this.dbSchemaUpgrade("engine", version6120Index);
                } else {
                    this.dbSchemaUpgrade("engine", matchingVersionIndex);
                }
                feedback = "upgraded Flowable from " + dbVersion + " to " + "6.7.1.0";
            } else if (!isEngineTablePresent) {
                this.dbSchemaCreateEngine();
            }
            if (isHistoryTablePresent) {
                if (isUpgradeNeeded) {
                    if (version6120Index > matchingVersionIndex) {
                        this.dbSchemaUpgrade("history", version6120Index);
                    } else {
                        this.dbSchemaUpgrade("history", matchingVersionIndex);
                    }
                }
            } else if (dbSqlSession.getDbSqlSessionFactory().isDbHistoryUsed()) {
                this.dbSchemaCreateHistory();
            }
            String string = feedback;
            return string;
        }
        finally {
            if (lockManager != null) {
                lockManager.releaseLock();
            }
        }
    }

    public boolean isEngineTablePresent() {
        return this.isTablePresent("ACT_RU_EXECUTION");
    }

    public boolean isHistoryTablePresent() {
        return this.isTablePresent("ACT_HI_PROCINST");
    }

    protected String getCleanVersion(String versionString) {
        Matcher matcher = CLEAN_VERSION_REGEX.matcher(versionString);
        if (!matcher.find()) {
            throw new FlowableException("Illegal format for version: " + versionString);
        }
        String cleanString = matcher.group();
        try {
            Double.parseDouble(cleanString);
            return cleanString;
        }
        catch (NumberFormatException nfe) {
            throw new FlowableException("Illegal format for version: " + versionString, (Throwable)nfe);
        }
    }

    protected boolean isMissingTablesException(Exception e) {
        String exceptionMessage = e.getMessage();
        if (e.getMessage() != null) {
            if (exceptionMessage.contains("Table") && exceptionMessage.contains("not found")) {
                return true;
            }
            if ((exceptionMessage.contains("Table") || exceptionMessage.contains("table")) && exceptionMessage.contains("doesn't exist")) {
                return true;
            }
            if ((exceptionMessage.contains("relation") || exceptionMessage.contains("table")) && exceptionMessage.contains("does not exist")) {
                return true;
            }
        }
        return false;
    }

    public void performSchemaOperationsProcessEngineClose() {
        String databaseSchemaUpdate = CommandContextUtil.getProcessEngineConfiguration().getDatabaseSchemaUpdate();
        if ("create-drop".equals(databaseSchemaUpdate)) {
            this.schemaDrop();
        }
    }

    protected SchemaManager getCommonSchemaManager() {
        return CommandContextUtil.getProcessEngineConfiguration().getCommonSchemaManager();
    }

    protected SchemaManager getIdentityLinkSchemaManager() {
        return CommandContextUtil.getProcessEngineConfiguration().getIdentityLinkSchemaManager();
    }

    protected SchemaManager getEntityLinkSchemaManager() {
        return CommandContextUtil.getProcessEngineConfiguration().getEntityLinkSchemaManager();
    }

    protected SchemaManager getEventSubscriptionSchemaManager() {
        return CommandContextUtil.getProcessEngineConfiguration().getEventSubscriptionSchemaManager();
    }

    protected SchemaManager getVariableSchemaManager() {
        return CommandContextUtil.getProcessEngineConfiguration().getVariableSchemaManager();
    }

    protected SchemaManager getTaskSchemaManager() {
        return CommandContextUtil.getProcessEngineConfiguration().getTaskSchemaManager();
    }

    protected SchemaManager getJobSchemaManager() {
        return CommandContextUtil.getProcessEngineConfiguration().getJobSchemaManager();
    }

    protected SchemaManager getBatchSchemaManager() {
        return CommandContextUtil.getProcessEngineConfiguration().getBatchSchemaManager();
    }

    protected ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        return CommandContextUtil.getProcessEngineConfiguration();
    }

    protected String getResourcesRootDirectory() {
        return "org/flowable/db/";
    }
}

