/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.async.json.transformer.AbstractNeedsTaskHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.identitylink.service.HistoricIdentityLinkService;
import org.flowable.identitylink.service.impl.persistence.entity.HistoricIdentityLinkEntity;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class TaskAssigneeChangedHistoryJsonTransformer
extends AbstractNeedsTaskHistoryJsonTransformer {
    public TaskAssigneeChangedHistoryJsonTransformer(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public List<String> getTypes() {
        return Collections.singletonList("task-assignee-changed");
    }

    @Override
    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        String activityAssigneeHandled = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"activityAssigneeHandled");
        if (activityAssigneeHandled != null && Boolean.valueOf(activityAssigneeHandled).booleanValue()) {
            return super.isApplicable(historicalData, commandContext);
        }
        String executionId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"executionId");
        if (StringUtils.isNotEmpty((CharSequence)executionId)) {
            return super.isApplicable(historicalData, commandContext) && this.historicActivityInstanceExistsForDataIncludingFinished(historicalData, commandContext);
        }
        return super.isApplicable(historicalData, commandContext);
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String taskId;
        String activityAssigneeHandled;
        String assignee = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"assignee");
        String executionId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"executionId");
        String activityId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"activityId");
        String runtimeActivityInstanceId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"runtimeActivityInstanceId");
        if (StringUtils.isNotEmpty((CharSequence)executionId) && StringUtils.isNotEmpty((CharSequence)activityId) && ((activityAssigneeHandled = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"activityAssigneeHandled")) == null || !Boolean.valueOf(activityAssigneeHandled).booleanValue())) {
            HistoricActivityInstanceEntity historicActivityInstanceEntity = StringUtils.isEmpty((CharSequence)runtimeActivityInstanceId) ? this.findHistoricActivityInstance(commandContext, executionId, activityId) : (HistoricActivityInstanceEntity)this.processEngineConfiguration.getHistoricActivityInstanceEntityManager().findById(runtimeActivityInstanceId);
            if (historicActivityInstanceEntity == null) {
                return;
            }
            historicActivityInstanceEntity.setAssignee(assignee);
        }
        if (StringUtils.isNotEmpty((CharSequence)(taskId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"id")))) {
            HistoricIdentityLinkService historicIdentityLinkService = this.processEngineConfiguration.getIdentityLinkServiceConfiguration().getHistoricIdentityLinkService();
            HistoricIdentityLinkEntity historicIdentityLinkEntity = historicIdentityLinkService.createHistoricIdentityLink();
            historicIdentityLinkEntity.setTaskId(taskId);
            historicIdentityLinkEntity.setType("assignee");
            historicIdentityLinkEntity.setUserId(assignee);
            historicIdentityLinkEntity.setCreateTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"createTime"));
            historicIdentityLinkService.insertHistoricIdentityLink(historicIdentityLinkEntity, false);
        }
    }
}

