/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.HistoryManager;
import org.flowable.engine.impl.persistence.entity.AbstractProcessEngineEntityManager;
import org.flowable.engine.impl.persistence.entity.CommentEntity;
import org.flowable.engine.impl.persistence.entity.CommentEntityManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.data.CommentDataManager;
import org.flowable.engine.task.Comment;
import org.flowable.engine.task.Event;

public class CommentEntityManagerImpl
extends AbstractProcessEngineEntityManager<CommentEntity, CommentDataManager>
implements CommentEntityManager {
    public CommentEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, CommentDataManager commentDataManager) {
        super(processEngineConfiguration, commentDataManager);
    }

    public void insert(CommentEntity commentEntity) {
        this.checkHistoryEnabled();
        this.insert(commentEntity, false);
        CommentEntity comment = commentEntity;
        if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
            ExecutionEntity process;
            String processDefinitionId = null;
            String processInstanceId = comment.getProcessInstanceId();
            if (comment.getProcessInstanceId() != null && (process = (ExecutionEntity)this.getExecutionEntityManager().findById(comment.getProcessInstanceId())) != null) {
                processDefinitionId = process.getProcessDefinitionId();
            }
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_CREATED, commentEntity, processInstanceId, processInstanceId, processDefinitionId), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_INITIALIZED, commentEntity, processInstanceId, processInstanceId, processDefinitionId), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
        }
    }

    public CommentEntity update(CommentEntity commentEntity) {
        this.checkHistoryEnabled();
        CommentEntity updatedCommentEntity = (CommentEntity)this.update(commentEntity, false);
        if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
            ExecutionEntity process;
            String processDefinitionId = null;
            String processInstanceId = updatedCommentEntity.getProcessInstanceId();
            if (updatedCommentEntity.getProcessInstanceId() != null && (process = (ExecutionEntity)this.getExecutionEntityManager().findById(updatedCommentEntity.getProcessInstanceId())) != null) {
                processDefinitionId = process.getProcessDefinitionId();
            }
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_UPDATED, commentEntity, processInstanceId, processInstanceId, processDefinitionId), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
        }
        return updatedCommentEntity;
    }

    @Override
    public List<Comment> findCommentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        return ((CommentDataManager)this.dataManager).findCommentsByTaskId(taskId);
    }

    @Override
    public List<Comment> findCommentsByTaskIdAndType(String taskId, String type) {
        this.checkHistoryEnabled();
        return ((CommentDataManager)this.dataManager).findCommentsByTaskIdAndType(taskId, type);
    }

    @Override
    public List<Comment> findCommentsByType(String type) {
        this.checkHistoryEnabled();
        return ((CommentDataManager)this.dataManager).findCommentsByType(type);
    }

    @Override
    public List<Event> findEventsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        return ((CommentDataManager)this.dataManager).findEventsByTaskId(taskId);
    }

    @Override
    public List<Event> findEventsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        return ((CommentDataManager)this.dataManager).findEventsByProcessInstanceId(processInstanceId);
    }

    @Override
    public void deleteCommentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        ((CommentDataManager)this.dataManager).deleteCommentsByTaskId(taskId);
    }

    @Override
    public void deleteCommentsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        ((CommentDataManager)this.dataManager).deleteCommentsByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<Comment> findCommentsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        return ((CommentDataManager)this.dataManager).findCommentsByProcessInstanceId(processInstanceId);
    }

    @Override
    public List<Comment> findCommentsByProcessInstanceId(String processInstanceId, String type) {
        this.checkHistoryEnabled();
        return ((CommentDataManager)this.dataManager).findCommentsByProcessInstanceId(processInstanceId, type);
    }

    @Override
    public Comment findComment(String commentId) {
        return ((CommentDataManager)this.dataManager).findComment(commentId);
    }

    @Override
    public Event findEvent(String commentId) {
        return ((CommentDataManager)this.dataManager).findEvent(commentId);
    }

    public void delete(CommentEntity commentEntity) {
        this.checkHistoryEnabled();
        this.delete(commentEntity, false);
        CommentEntity comment = commentEntity;
        if (this.getEventDispatcher() != null && this.getEventDispatcher().isEnabled()) {
            ExecutionEntity process;
            String processDefinitionId = null;
            String processInstanceId = comment.getProcessInstanceId();
            if (comment.getProcessInstanceId() != null && (process = (ExecutionEntity)this.getExecutionEntityManager().findById(comment.getProcessInstanceId())) != null) {
                processDefinitionId = process.getProcessDefinitionId();
            }
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, commentEntity, processInstanceId, processInstanceId, processDefinitionId), ((ProcessEngineConfigurationImpl)this.engineConfiguration).getEngineCfgKey());
        }
    }

    protected void checkHistoryEnabled() {
        if (!this.getHistoryManager().isHistoryEnabled()) {
            throw new FlowableException("In order to use comments, history should be enabled");
        }
    }

    protected ExecutionEntityManager getExecutionEntityManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getExecutionEntityManager();
    }

    protected HistoryManager getHistoryManager() {
        return ((ProcessEngineConfigurationImpl)this.engineConfiguration).getHistoryManager();
    }
}

