/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.rest.service.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.entity.ContentType;
import org.flowable.common.rest.resolver.ContentTypeResolver;
import org.flowable.common.rest.util.RestUrlBuilder;
import org.flowable.eventregistry.api.ChannelDefinition;
import org.flowable.eventregistry.api.EventDefinition;
import org.flowable.eventregistry.api.EventDeployment;
import org.flowable.eventregistry.impl.deployer.ParsedDeploymentBuilder;
import org.flowable.eventregistry.rest.service.api.EventRestUrls;
import org.flowable.eventregistry.rest.service.api.repository.ChannelDefinitionResponse;
import org.flowable.eventregistry.rest.service.api.repository.DeploymentResourceResponse;
import org.flowable.eventregistry.rest.service.api.repository.EventDefinitionResponse;
import org.flowable.eventregistry.rest.service.api.repository.EventDeploymentResponse;

public class EventRegistryRestResponseFactory {
    protected ObjectMapper objectMapper;

    public EventRegistryRestResponseFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public List<EventDeploymentResponse> createDeploymentResponseList(List<EventDeployment> deployments) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<EventDeploymentResponse> responseList = new ArrayList<EventDeploymentResponse>();
        for (EventDeployment instance : deployments) {
            responseList.add(this.createDeploymentResponse(instance, urlBuilder));
        }
        return responseList;
    }

    public EventDeploymentResponse createDeploymentResponse(EventDeployment deployment) {
        return this.createDeploymentResponse(deployment, this.createUrlBuilder());
    }

    public EventDeploymentResponse createDeploymentResponse(EventDeployment deployment, RestUrlBuilder urlBuilder) {
        return new EventDeploymentResponse(deployment, urlBuilder.buildUrl(EventRestUrls.URL_DEPLOYMENT, new Object[]{deployment.getId()}));
    }

    public List<DeploymentResourceResponse> createDeploymentResourceResponseList(String deploymentId, List<String> resourceList, ContentTypeResolver contentTypeResolver) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<DeploymentResourceResponse> responseList = new ArrayList<DeploymentResourceResponse>();
        for (String resourceId : resourceList) {
            String contentType = null;
            contentType = resourceId.toLowerCase().endsWith(".cmmn") ? ContentType.TEXT_XML.getMimeType() : contentTypeResolver.resolveContentType(resourceId);
            responseList.add(this.createDeploymentResourceResponse(deploymentId, resourceId, contentType, urlBuilder));
        }
        return responseList;
    }

    public DeploymentResourceResponse createDeploymentResourceResponse(String deploymentId, String resourceId, String contentType) {
        return this.createDeploymentResourceResponse(deploymentId, resourceId, contentType, this.createUrlBuilder());
    }

    public DeploymentResourceResponse createDeploymentResourceResponse(String deploymentId, String resourceId, String contentType, RestUrlBuilder urlBuilder) {
        String resourceUrl = urlBuilder.buildUrl(EventRestUrls.URL_DEPLOYMENT_RESOURCE, new Object[]{deploymentId, resourceId});
        String resourceContentUrl = urlBuilder.buildUrl(EventRestUrls.URL_DEPLOYMENT_RESOURCE_CONTENT, new Object[]{deploymentId, resourceId});
        String type = "resource";
        for (String suffix : ParsedDeploymentBuilder.EVENT_RESOURCE_SUFFIXES) {
            if (!resourceId.endsWith(suffix)) continue;
            type = "eventDefinition";
            break;
        }
        for (String suffix : ParsedDeploymentBuilder.CHANNEL_RESOURCE_SUFFIXES) {
            if (!resourceId.endsWith(suffix)) continue;
            type = "channelDefinition";
            break;
        }
        return new DeploymentResourceResponse(resourceId, resourceUrl, resourceContentUrl, contentType, type);
    }

    public List<EventDefinitionResponse> createEventDefinitionResponseList(List<EventDefinition> eventDefinitions) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<EventDefinitionResponse> responseList = new ArrayList<EventDefinitionResponse>();
        for (EventDefinition eventDef : eventDefinitions) {
            responseList.add(this.createEventDefinitionResponse(eventDef, urlBuilder));
        }
        return responseList;
    }

    public EventDefinitionResponse createEventDefinitionResponse(EventDefinition eventDefinition) {
        return this.createEventDefinitionResponse(eventDefinition, this.createUrlBuilder());
    }

    public EventDefinitionResponse createEventDefinitionResponse(EventDefinition eventDefinition, RestUrlBuilder urlBuilder) {
        EventDefinitionResponse response = new EventDefinitionResponse();
        response.setUrl(urlBuilder.buildUrl(EventRestUrls.URL_EVENT_DEFINITION, new Object[]{eventDefinition.getId()}));
        response.setId(eventDefinition.getId());
        response.setKey(eventDefinition.getKey());
        response.setVersion(eventDefinition.getVersion());
        response.setCategory(eventDefinition.getCategory());
        response.setName(eventDefinition.getName());
        response.setDescription(eventDefinition.getDescription());
        response.setTenantId(eventDefinition.getTenantId());
        response.setDeploymentId(eventDefinition.getDeploymentId());
        response.setDeploymentUrl(urlBuilder.buildUrl(EventRestUrls.URL_DEPLOYMENT, new Object[]{eventDefinition.getDeploymentId()}));
        response.setResource(urlBuilder.buildUrl(EventRestUrls.URL_DEPLOYMENT_RESOURCE, new Object[]{eventDefinition.getDeploymentId(), eventDefinition.getResourceName()}));
        return response;
    }

    public List<ChannelDefinitionResponse> createChannelDefinitionResponseList(List<ChannelDefinition> channelDefinitions) {
        RestUrlBuilder urlBuilder = this.createUrlBuilder();
        ArrayList<ChannelDefinitionResponse> responseList = new ArrayList<ChannelDefinitionResponse>();
        for (ChannelDefinition channelDef : channelDefinitions) {
            responseList.add(this.createChannelDefinitionResponse(channelDef, urlBuilder));
        }
        return responseList;
    }

    public ChannelDefinitionResponse createChannelDefinitionResponse(ChannelDefinition channelDefinition) {
        return this.createChannelDefinitionResponse(channelDefinition, this.createUrlBuilder());
    }

    public ChannelDefinitionResponse createChannelDefinitionResponse(ChannelDefinition channelDefinition, RestUrlBuilder urlBuilder) {
        ChannelDefinitionResponse response = new ChannelDefinitionResponse();
        response.setUrl(urlBuilder.buildUrl(EventRestUrls.URL_CHANNEL_DEFINITION, new Object[]{channelDefinition.getId()}));
        response.setId(channelDefinition.getId());
        response.setKey(channelDefinition.getKey());
        response.setVersion(channelDefinition.getVersion());
        response.setCategory(channelDefinition.getCategory());
        response.setName(channelDefinition.getName());
        response.setCreateTime(channelDefinition.getCreateTime());
        response.setDescription(channelDefinition.getDescription());
        response.setTenantId(channelDefinition.getTenantId());
        response.setDeploymentId(channelDefinition.getDeploymentId());
        response.setDeploymentUrl(urlBuilder.buildUrl(EventRestUrls.URL_DEPLOYMENT, new Object[]{channelDefinition.getDeploymentId()}));
        response.setResource(urlBuilder.buildUrl(EventRestUrls.URL_DEPLOYMENT_RESOURCE, new Object[]{channelDefinition.getDeploymentId(), channelDefinition.getResourceName()}));
        return response;
    }

    protected String formatUrl(String serverRootUrl, String[] fragments, Object ... arguments) {
        StringBuilder urlBuilder = new StringBuilder(serverRootUrl);
        for (String urlFragment : fragments) {
            urlBuilder.append("/");
            urlBuilder.append(MessageFormat.format(urlFragment, arguments));
        }
        return urlBuilder.toString();
    }

    protected RestUrlBuilder createUrlBuilder() {
        return RestUrlBuilder.fromCurrentRequest();
    }
}

