/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import org.flowable.eventregistry.api.EventDefinition;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.rest.service.api.repository.BaseEventDefinitionResource;
import org.flowable.eventregistry.rest.service.api.repository.EventDefinitionResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Event Definitions"}, description="Manage Event Definitions", authorizations={@Authorization(value="basicAuth")})
public class EventDefinitionResource
extends BaseEventDefinitionResource {
    @Autowired
    protected EventRegistryEngineConfiguration eventRegistryEngineConfiguration;
    @Autowired(required=false)
    protected EventRepositoryService eventRepositoryService;

    @ApiOperation(value="Get an event definition", tags={"Case Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates request was successful and the event definitions are returned"), @ApiResponse(code=404, message="Indicates the requested event definition was not found.")})
    @GetMapping(value={"/event-registry-repository/event-definitions/{eventDefinitionId}"}, produces={"application/json"})
    public EventDefinitionResponse getEventDefinition(@ApiParam(name="eventDefinitionId") @PathVariable String eventDefinitionId, HttpServletRequest request) {
        EventDefinition eventDefinition = this.getEventDefinitionFromRequest(eventDefinitionId);
        return this.restResponseFactory.createEventDefinitionResponse(eventDefinition);
    }
}

