/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.servlet.http.HttpServletResponse;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.eventregistry.api.ChannelDefinition;
import org.flowable.eventregistry.rest.service.api.repository.BaseDeploymentResourceDataResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Channel Definitions"}, description="Manage Channel Definitions", authorizations={@Authorization(value="basicAuth")})
public class ChannelDefinitionResourceDataResource
extends BaseDeploymentResourceDataResource {
    @ApiOperation(value="Get a channel definition resource content", tags={"Channel Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates both channel definition and resource have been found and the resource data has been returned."), @ApiResponse(code=404, message="Indicates the requested channel definition was not found or there is no resource with the given id present in the channel definition. The status-description contains additional information.")})
    @GetMapping(value={"/event-registry-repository/channel-definitions/{channelDefinitionId}/resourcedata"})
    public byte[] getChannelDefinitionResource(@ApiParam(name="channelDefinitionId") @PathVariable String channelDefinitionId, HttpServletResponse response) {
        ChannelDefinition channelDefinition = this.getChannelDefinitionFromRequest(channelDefinitionId);
        return this.getDeploymentResourceData(channelDefinition.getDeploymentId(), channelDefinition.getResourceName(), response);
    }

    protected ChannelDefinition getChannelDefinitionFromRequest(String channelDefinitionId) {
        ChannelDefinition channelDefinition = (ChannelDefinition)this.repositoryService.createChannelDefinitionQuery().channelDefinitionId(channelDefinitionId).singleResult();
        if (channelDefinition == null) {
            throw new FlowableObjectNotFoundException("Could not find a channel definition with id '" + channelDefinitionId + "'.", ChannelDefinition.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessChannelDefinitionById(channelDefinition);
        }
        return channelDefinition;
    }
}

