/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.rest.service.api.runtime;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.eventregistry.api.EventDefinition;
import org.flowable.eventregistry.api.EventDefinitionQuery;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.InboundChannelModel;
import org.flowable.eventregistry.rest.service.api.EventRegistryRestApiInterceptor;
import org.flowable.eventregistry.rest.service.api.EventRegistryRestResponseFactory;
import org.flowable.eventregistry.rest.service.api.runtime.EventInstanceCreateRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Event Instances"}, description="Manage Event Instances", authorizations={@Authorization(value="basicAuth")})
public class EventInstanceCollectionResource {
    @Autowired
    protected EventRegistryRestResponseFactory restResponseFactory;
    @Autowired
    protected EventRegistry eventRegistry;
    @Autowired
    protected EventRepositoryService repositoryService;
    @Autowired
    protected EventRegistryEngineConfiguration eventRegistryEngineConfiguration;
    @Autowired(required=false)
    protected EventRegistryRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="Send an event instance", tags={"Event Instances"}, notes="Only one of *eventDefinitionId* or *eventDefinitionKey* an be used in the request body. \n\n", code=204)
    @ApiResponses(value={@ApiResponse(code=204, message="Indicates the event instance was created."), @ApiResponse(code=400, message="Indicates either the event definition was not found (based on id or key), no event was send. Status description contains additional information about the error.")})
    @PostMapping(value={"/event-registry-runtime/event-instances"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void createEventInstance(@RequestBody EventInstanceCreateRequest request) {
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.createEventInstance(request);
        }
        this.validateRequestParameters(request);
        EventDefinition eventDefinition = null;
        if (request.getEventDefinitionId() != null) {
            eventDefinition = this.repositoryService.getEventDefinition(request.getEventDefinitionId());
        } else {
            EventDefinitionQuery eventDefinitionQuery = this.repositoryService.createEventDefinitionQuery().eventDefinitionKey(request.getEventDefinitionKey());
            if (StringUtils.isNotEmpty((CharSequence)request.getTenantId())) {
                eventDefinitionQuery.tenantId(request.getTenantId());
            }
            if ((eventDefinition = (EventDefinition)eventDefinitionQuery.latestVersion().singleResult()) == null && this.eventRegistryEngineConfiguration.isFallbackToDefaultTenant()) {
                String defaultTenant = this.eventRegistryEngineConfiguration.getDefaultTenantProvider().getDefaultTenant(request.getTenantId(), "eventRegistry", request.getEventDefinitionKey());
                eventDefinitionQuery = StringUtils.isNotEmpty((CharSequence)defaultTenant) ? this.repositoryService.createEventDefinitionQuery().eventDefinitionKey(request.getEventDefinitionKey()).tenantId(defaultTenant) : this.repositoryService.createEventDefinitionQuery().eventDefinitionKey(request.getEventDefinitionKey());
                eventDefinition = (EventDefinition)eventDefinitionQuery.latestVersion().singleResult();
            }
        }
        if (eventDefinition == null) {
            throw new FlowableObjectNotFoundException("No event definition found");
        }
        ChannelModel channelModel = null;
        channelModel = StringUtils.isNotEmpty((CharSequence)request.getChannelDefinitionId()) ? this.repositoryService.getChannelModelById(request.getChannelDefinitionId()) : (StringUtils.isNotEmpty((CharSequence)request.getTenantId()) ? this.repositoryService.getChannelModelByKey(request.getChannelDefinitionKey(), request.getTenantId()) : this.repositoryService.getChannelModelByKey(request.getChannelDefinitionKey()));
        this.eventRegistry.eventReceived((InboundChannelModel)channelModel, request.getEventPayload().toString());
    }

    protected void validateRequestParameters(@RequestBody EventInstanceCreateRequest request) {
        if (request.getEventDefinitionId() == null && request.getEventDefinitionKey() == null) {
            throw new FlowableIllegalArgumentException("Either eventDefinitionId or eventDefinitionKey is required.");
        }
        int paramsSet = (request.getEventDefinitionId() != null ? 1 : 0) + (request.getEventDefinitionKey() != null ? 1 : 0);
        if (paramsSet > 1) {
            throw new FlowableIllegalArgumentException("Only one of eventDefinitionId or eventDefinitionKey should be set.");
        }
        if (request.getChannelDefinitionId() == null && request.getChannelDefinitionKey() == null) {
            throw new FlowableIllegalArgumentException("Either channelDefinitionId or channelDefinitionKey is required.");
        }
        paramsSet = (request.getChannelDefinitionId() != null ? 1 : 0) + (request.getChannelDefinitionKey() != null ? 1 : 0);
        if (paramsSet > 1) {
            throw new FlowableIllegalArgumentException("Only one of eventDefinitionId or eventDefinitionKey should be set.");
        }
    }
}

