/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.kafka;

import java.util.concurrent.ExecutionException;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.eventregistry.api.OutboundEventChannelAdapter;
import org.springframework.kafka.core.KafkaOperations;

public class KafkaOperationsOutboundEventChannelAdapter
implements OutboundEventChannelAdapter {
    protected KafkaOperations<Object, Object> kafkaOperations;
    protected String topic;
    protected String key;

    public KafkaOperationsOutboundEventChannelAdapter(KafkaOperations<Object, Object> kafkaOperations, String topic, String key) {
        this.kafkaOperations = kafkaOperations;
        this.topic = topic;
        this.key = key;
    }

    public void sendEvent(String rawEvent) {
        try {
            this.kafkaOperations.send(this.topic, (Object)this.key, (Object)rawEvent).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new FlowableException("failed to send event", e.getCause());
        }
    }
}

