/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl;

import java.util.Collection;
import java.util.Objects;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.api.OutboundEventChannelAdapter;
import org.flowable.eventregistry.api.OutboundEventProcessingPipeline;
import org.flowable.eventregistry.api.OutboundEventProcessor;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.OutboundChannelModel;

public class DefaultOutboundEventProcessor
implements OutboundEventProcessor {
    protected EventRepositoryService eventRepositoryService;
    protected boolean fallbackToDefaultTenant;

    public DefaultOutboundEventProcessor(EventRepositoryService eventRepositoryService, boolean fallbackToDefaultTenant) {
        this.eventRepositoryService = eventRepositoryService;
        this.fallbackToDefaultTenant = fallbackToDefaultTenant;
    }

    public void sendEvent(EventInstance eventInstance) {
        Collection outboundChannelKeys = eventInstance.getEventModel().getOutboundChannelKeys();
        for (String outboundChannelKey : outboundChannelKeys) {
            ChannelModel channelModel = null;
            channelModel = Objects.equals("", eventInstance.getTenantId()) ? this.eventRepositoryService.getChannelModelByKey(outboundChannelKey) : this.eventRepositoryService.getChannelModelByKey(outboundChannelKey, eventInstance.getTenantId());
            if (channelModel == null) {
                throw new FlowableException("Could not find outbound channel model for " + outboundChannelKey);
            }
            if (!(channelModel instanceof OutboundChannelModel)) {
                throw new FlowableException("Channel model is not an outbound channel model for " + outboundChannelKey);
            }
            OutboundChannelModel outboundChannelModel = (OutboundChannelModel)channelModel;
            OutboundEventProcessingPipeline outboundEventProcessingPipeline = (OutboundEventProcessingPipeline)outboundChannelModel.getOutboundEventProcessingPipeline();
            String rawEvent = outboundEventProcessingPipeline.run(eventInstance);
            OutboundEventChannelAdapter outboundEventChannelAdapter = (OutboundEventChannelAdapter)outboundChannelModel.getOutboundEventChannelAdapter();
            if (outboundEventChannelAdapter == null) {
                throw new FlowableException("Could not find an outbound channel adapter for channel " + outboundChannelKey);
            }
            outboundEventChannelAdapter.sendEvent(rawEvent);
        }
    }
}

