/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.payload;

import java.util.Collection;
import java.util.stream.Collectors;
import org.flowable.eventregistry.api.InboundEventPayloadExtractor;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;
import org.flowable.eventregistry.impl.runtime.EventPayloadInstanceImpl;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.eventregistry.model.EventPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlElementsToMapPayloadExtractor
implements InboundEventPayloadExtractor<Document> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlElementsToMapPayloadExtractor.class);

    public Collection<EventPayloadInstance> extractPayload(EventModel eventDefinition, Document event) {
        return eventDefinition.getPayload().stream().filter(parameterDefinition -> this.getChildNode(event, parameterDefinition.getName()) != null).map(payloadDefinition -> new EventPayloadInstanceImpl((EventPayload)payloadDefinition, this.getPayloadValue(event, payloadDefinition.getName(), payloadDefinition.getType()))).collect(Collectors.toList());
    }

    protected Object getPayloadValue(Document document, String definitionName, String definitionType) {
        Node childNode = this.getChildNode(document, definitionName);
        if (childNode != null) {
            String textContent = childNode.getTextContent();
            if ("string".equals(definitionType)) {
                return textContent;
            }
            if ("boolean".equals(definitionType)) {
                return Boolean.valueOf(textContent);
            }
            if ("integer".equals(definitionType)) {
                return Integer.valueOf(textContent);
            }
            if ("double".equals(definitionType)) {
                return Double.valueOf(textContent);
            }
            if ("long".equals(definitionType)) {
                return Long.valueOf(textContent);
            }
            LOGGER.warn("Unsupported payload type: {} ", (Object)definitionType);
            return textContent;
        }
        return null;
    }

    protected Node getChildNode(Document document, String elementName) {
        NodeList childNodes = null;
        childNodes = document.getChildNodes().getLength() == 1 ? document.getFirstChild().getChildNodes() : document.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!elementName.equals(node.getNodeName())) continue;
            return node;
        }
        return null;
    }
}

