/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.EngineInfo;
import org.flowable.common.engine.impl.util.ReflectUtil;
import org.flowable.eventregistry.impl.EventRegistryEngine;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventRegistryEngines {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventRegistryEngines.class);
    public static final String NAME_DEFAULT = "default";
    protected static boolean isInitialized;
    protected static Map<String, EventRegistryEngine> eventRegistryEngines;
    protected static Map<String, EngineInfo> eventRegistryEngineInfosByName;
    protected static Map<String, EngineInfo> eventRegistryEngineInfosByResourceUrl;
    protected static List<EngineInfo> eventRegistryEngineInfos;

    public static synchronized void init() {
        if (!EventRegistryEngines.isInitialized()) {
            if (eventRegistryEngines == null) {
                eventRegistryEngines = new HashMap<String, EventRegistryEngine>();
            }
            ClassLoader classLoader = EventRegistryEngines.class.getClassLoader();
            Enumeration<URL> resources = null;
            try {
                resources = classLoader.getResources("flowable.eventregistry.cfg.xml");
            }
            catch (IOException e) {
                throw new FlowableException("problem retrieving flowable.registry.cfg.xml resources on the classpath: " + System.getProperty("java.class.path"), (Throwable)e);
            }
            HashSet<URL> configUrls = new HashSet<URL>();
            while (resources.hasMoreElements()) {
                configUrls.add(resources.nextElement());
            }
            for (URL resource : configUrls) {
                LOGGER.info("Initializing event registry engine using configuration '{}'", (Object)resource);
                EventRegistryEngines.initEventRegistryEngineFromResource(resource);
            }
            try {
                resources = classLoader.getResources("flowable-eventregistry-context.xml");
            }
            catch (IOException e) {
                throw new FlowableException("problem retrieving flowable-registry-context.xml resources on the classpath: " + System.getProperty("java.class.path"), (Throwable)e);
            }
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                LOGGER.info("Initializing event registry engine using Spring configuration '{}'", (Object)resource);
                EventRegistryEngines.initEventRegistryEngineFromSpringResource(resource);
            }
            EventRegistryEngines.setInitialized(true);
        } else {
            LOGGER.info("Event registry engines already initialized");
        }
    }

    protected static void initEventRegistryEngineFromSpringResource(URL resource) {
        try {
            Class springConfigurationHelperClass = ReflectUtil.loadClass((String)"org.flowable.eventregistry.impl.spring.SpringEventRegistryConfigurationHelper");
            Method method = springConfigurationHelperClass.getDeclaredMethod("buildEventRegistryEngine", URL.class);
            EventRegistryEngine eventRegistryEngine = (EventRegistryEngine)method.invoke(null, resource);
            String eventRegistryEngineName = eventRegistryEngine.getName();
            EngineInfo eventRegistryEngineInfo = new EngineInfo(eventRegistryEngineName, resource.toString(), null);
            eventRegistryEngineInfosByName.put(eventRegistryEngineName, eventRegistryEngineInfo);
            eventRegistryEngineInfosByResourceUrl.put(resource.toString(), eventRegistryEngineInfo);
        }
        catch (Exception e) {
            throw new FlowableException("couldn't initialize event registry engine from spring configuration resource " + resource + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public static void registerEventRegistryEngine(EventRegistryEngine eventRegistryEngine) {
        eventRegistryEngines.put(eventRegistryEngine.getName(), eventRegistryEngine);
    }

    public static void unregister(EventRegistryEngine eventRegistryEngine) {
        eventRegistryEngines.remove(eventRegistryEngine.getName());
    }

    private static EngineInfo initEventRegistryEngineFromResource(URL resourceUrl) {
        EngineInfo eventRegistryEngineInfo = eventRegistryEngineInfosByResourceUrl.get(resourceUrl.toString());
        if (eventRegistryEngineInfo != null) {
            eventRegistryEngineInfos.remove(eventRegistryEngineInfo);
            if (eventRegistryEngineInfo.getException() == null) {
                String eventRegistryEngineName = eventRegistryEngineInfo.getName();
                eventRegistryEngines.remove(eventRegistryEngineName);
                eventRegistryEngineInfosByName.remove(eventRegistryEngineName);
            }
            eventRegistryEngineInfosByResourceUrl.remove(eventRegistryEngineInfo.getResourceUrl());
        }
        String resourceUrlString = resourceUrl.toString();
        try {
            LOGGER.info("initializing event registry engine for resource {}", (Object)resourceUrl);
            EventRegistryEngine eventRegistryEngine = EventRegistryEngines.buildEventRegistryEngine(resourceUrl);
            String eventRegistryEngineName = eventRegistryEngine.getName();
            LOGGER.info("initialised event registry engine {}", (Object)eventRegistryEngineName);
            eventRegistryEngineInfo = new EngineInfo(eventRegistryEngineName, resourceUrlString, null);
            eventRegistryEngines.put(eventRegistryEngineName, eventRegistryEngine);
            eventRegistryEngineInfosByName.put(eventRegistryEngineName, eventRegistryEngineInfo);
        }
        catch (Throwable e) {
            LOGGER.error("Exception while initializing event registry engine: {}", (Object)e.getMessage(), (Object)e);
            eventRegistryEngineInfo = new EngineInfo(null, resourceUrlString, ExceptionUtils.getStackTrace((Throwable)e));
        }
        eventRegistryEngineInfosByResourceUrl.put(resourceUrlString, eventRegistryEngineInfo);
        eventRegistryEngineInfos.add(eventRegistryEngineInfo);
        return eventRegistryEngineInfo;
    }

    protected static EventRegistryEngine buildEventRegistryEngine(URL resource) {
        EventRegistryEngine eventRegistryEngine;
        block8: {
            InputStream inputStream = resource.openStream();
            try {
                EventRegistryEngineConfiguration eventRegistryEngineConfiguration = EventRegistryEngineConfiguration.createEventRegistryEngineConfigurationFromInputStream(inputStream);
                eventRegistryEngine = eventRegistryEngineConfiguration.buildEventRegistryEngine();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FlowableException("couldn't open resource stream: " + e.getMessage(), (Throwable)e);
                }
            }
            inputStream.close();
        }
        return eventRegistryEngine;
    }

    public static List<EngineInfo> getEventRegistryEngineInfos() {
        return eventRegistryEngineInfos;
    }

    public static EngineInfo getEventRegistryEngineInfo(String eventRegistryEngineName) {
        return eventRegistryEngineInfosByName.get(eventRegistryEngineName);
    }

    public static EventRegistryEngine getDefaultEventRegistryEngine() {
        return EventRegistryEngines.getEventRegistryEngine(NAME_DEFAULT);
    }

    public static EventRegistryEngine getEventRegistryEngine(String eventRegistryEngineName) {
        if (!EventRegistryEngines.isInitialized()) {
            EventRegistryEngines.init();
        }
        return eventRegistryEngines.get(eventRegistryEngineName);
    }

    public static EngineInfo retry(String resourceUrl) {
        LOGGER.debug("retying initializing of resource {}", (Object)resourceUrl);
        try {
            return EventRegistryEngines.initEventRegistryEngineFromResource(new URL(resourceUrl));
        }
        catch (MalformedURLException e) {
            throw new FlowableException("invalid url: " + resourceUrl, (Throwable)e);
        }
    }

    public static Map<String, EventRegistryEngine> getEventRegistryEngines() {
        return eventRegistryEngines;
    }

    public static synchronized void destroy() {
        if (EventRegistryEngines.isInitialized()) {
            HashMap<String, EventRegistryEngine> engines = new HashMap<String, EventRegistryEngine>(eventRegistryEngines);
            eventRegistryEngines = new HashMap<String, EventRegistryEngine>();
            for (String eventRegistryEngineName : engines.keySet()) {
                EventRegistryEngine eventRegistryEngine = (EventRegistryEngine)engines.get(eventRegistryEngineName);
                try {
                    eventRegistryEngine.close();
                }
                catch (Exception e) {
                    LOGGER.error("exception while closing {}", eventRegistryEngineName == null ? "the default event registry engine" : "event registry engine " + eventRegistryEngineName, (Object)e);
                }
            }
            eventRegistryEngineInfosByName.clear();
            eventRegistryEngineInfosByResourceUrl.clear();
            eventRegistryEngineInfos.clear();
            EventRegistryEngines.setInitialized(false);
        }
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static void setInitialized(boolean isInitialized) {
        EventRegistryEngines.isInitialized = isInitialized;
    }

    static {
        eventRegistryEngines = new HashMap<String, EventRegistryEngine>();
        eventRegistryEngineInfosByName = new HashMap<String, EngineInfo>();
        eventRegistryEngineInfosByResourceUrl = new HashMap<String, EngineInfo>();
        eventRegistryEngineInfos = new ArrayList<EngineInfo>();
    }
}

