/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.process;

import com.vaadin.terminal.ExternalResource;
import com.vaadin.terminal.Resource;
import com.vaadin.terminal.StreamResource;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Job;
import org.activiti.engine.runtime.JobQuery;
import org.activiti.explorer.Constants;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.process.ProcessDefinitionImageStreamResourceBuilder;
import org.activiti.explorer.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDefinitionInfoComponent
extends VerticalLayout {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(ProcessDefinitionInfoComponent.class);
    protected transient RepositoryService repositoryService = ProcessEngines.getDefaultProcessEngine().getRepositoryService();
    protected transient ManagementService managementService = ProcessEngines.getDefaultProcessEngine().getManagementService();
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected ProcessDefinition processDefinition;
    protected Deployment deployment;
    protected HorizontalLayout timeDetails;
    protected VerticalLayout processImageContainer;

    public ProcessDefinitionInfoComponent(ProcessDefinition processDefinition, Deployment deployment) {
        this.processDefinition = processDefinition;
        this.deployment = deployment;
        this.addStyleName("block-holder");
        this.initSuspensionStateInformation();
        this.initImage();
    }

    protected void initSuspensionStateInformation() {
        List jobs = ((JobQuery)this.managementService.createJobQuery().processDefinitionId(this.processDefinition.getId()).orderByJobDuedate().asc()).list();
        ArrayList<JobEntity> suspensionStateJobs = new ArrayList<JobEntity>();
        for (Job job : jobs) {
            JobEntity jobEntity = (JobEntity)job;
            if (!jobEntity.getJobHandlerType().equals("suspend-processdefinition") && !jobEntity.getJobHandlerType().equals("activate-processdefinition")) continue;
            suspensionStateJobs.add(jobEntity);
        }
        if (!suspensionStateJobs.isEmpty()) {
            Label suspensionStateTitle = new Label(this.i18nManager.getMessage("process.header.suspension.state"));
            suspensionStateTitle.addStyleName("h3");
            this.addComponent((Component)suspensionStateTitle);
            this.addEmptySpace((ComponentContainer)this);
            for (JobEntity jobEntity : suspensionStateJobs) {
                Label suspendLabel;
                if (jobEntity.getJobHandlerType().equals("suspend-processdefinition")) {
                    suspendLabel = new Label(this.i18nManager.getMessage("process.scheduled.suspend", Constants.DEFAULT_TIME_FORMATTER.format(jobEntity.getDuedate())), 3);
                    this.addComponent((Component)suspendLabel);
                    continue;
                }
                if (!jobEntity.getJobHandlerType().equals("activate-processdefinition")) continue;
                suspendLabel = new Label(this.i18nManager.getMessage("process.scheduled.activate", Constants.DEFAULT_TIME_FORMATTER.format(jobEntity.getDuedate())), 3);
                this.addComponent((Component)suspendLabel);
            }
        }
        this.addEmptySpace((ComponentContainer)this);
    }

    protected void initImage() {
        this.processImageContainer = new VerticalLayout();
        Label processTitle = new Label(this.i18nManager.getMessage("process.header.diagram"));
        processTitle.addStyleName("h3");
        this.processImageContainer.addComponent((Component)processTitle);
        boolean didDrawImage = false;
        if (ExplorerApp.get().isUseJavascriptDiagram()) {
            try {
                InputStream definitionStream = this.repositoryService.getResourceAsStream(this.processDefinition.getDeploymentId(), this.processDefinition.getResourceName());
                XMLInputFactory xif = XmlUtil.createSafeXmlInputFactory();
                XMLStreamReader xtr = xif.createXMLStreamReader(definitionStream);
                BpmnModel bpmnModel = new BpmnXMLConverter().convertToBpmnModel(xtr);
                if (!bpmnModel.getFlowLocationMap().isEmpty()) {
                    int maxX = 0;
                    int maxY = 0;
                    for (String key : bpmnModel.getLocationMap().keySet()) {
                        double elementY;
                        GraphicInfo graphicInfo = bpmnModel.getGraphicInfo(key);
                        double elementX = graphicInfo.getX() + graphicInfo.getWidth();
                        if ((double)maxX < elementX) {
                            maxX = (int)elementX;
                        }
                        if (!((double)maxY < (elementY = graphicInfo.getY() + graphicInfo.getHeight()))) continue;
                        maxY = (int)elementY;
                    }
                    Panel imagePanel = new Panel();
                    imagePanel.addStyleName("light");
                    imagePanel.setWidth(100.0f, 8);
                    imagePanel.setHeight(100.0f, 8);
                    URL explorerURL = ExplorerApp.get().getURL();
                    URL url = new URL(explorerURL.getProtocol(), explorerURL.getHost(), explorerURL.getPort(), explorerURL.getPath().replace("/ui", "") + "diagram-viewer/index.html?processDefinitionId=" + this.processDefinition.getId());
                    Embedded browserPanel = new Embedded("", (Resource)new ExternalResource(url));
                    browserPanel.setType(2);
                    browserPanel.setWidth(maxX + 350 + "px");
                    browserPanel.setHeight(maxY + 220 + "px");
                    HorizontalLayout panelLayout = new HorizontalLayout();
                    panelLayout.setSizeUndefined();
                    imagePanel.setContent((ComponentContainer)panelLayout);
                    imagePanel.addComponent((Component)browserPanel);
                    this.processImageContainer.addComponent((Component)imagePanel);
                    didDrawImage = true;
                }
            }
            catch (Exception e) {
                LOGGER.error("Error loading process diagram component", (Throwable)e);
            }
        }
        if (!didDrawImage) {
            StreamResource diagram = null;
            if (this.processDefinition.getDiagramResourceName() != null) {
                diagram = new ProcessDefinitionImageStreamResourceBuilder().buildStreamResource(this.processDefinition, this.repositoryService);
            }
            if (diagram != null) {
                Embedded embedded = new Embedded(null, diagram);
                embedded.setType(1);
                embedded.setSizeUndefined();
                Panel imagePanel = new Panel();
                imagePanel.addStyleName("light");
                imagePanel.setWidth(100.0f, 8);
                imagePanel.setHeight(100.0f, 8);
                HorizontalLayout panelLayout = new HorizontalLayout();
                panelLayout.setSizeUndefined();
                imagePanel.setContent((ComponentContainer)panelLayout);
                imagePanel.addComponent((Component)embedded);
                this.processImageContainer.addComponent((Component)imagePanel);
                didDrawImage = true;
            }
        }
        if (!didDrawImage) {
            Label noImageAvailable = new Label(this.i18nManager.getMessage("process.no.diagram"));
            this.processImageContainer.addComponent((Component)noImageAvailable);
        }
        this.addComponent((Component)this.processImageContainer);
    }

    protected void addEmptySpace(ComponentContainer container) {
        Label emptySpace = new Label("&nbsp;", 3);
        emptySpace.setSizeUndefined();
        container.addComponent((Component)emptySpace);
    }
}

