/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.task;

import com.vaadin.data.Validator;
import com.vaadin.event.Action;
import com.vaadin.event.ShortcutAction;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.DateField;
import com.vaadin.ui.Field;
import com.vaadin.ui.Form;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.TextField;
import java.util.Date;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.custom.PopupWindow;
import org.activiti.explorer.ui.task.PriorityComboBox;

public class NewCasePopupWindow
extends PopupWindow {
    private static final long serialVersionUID = 1L;
    protected transient TaskService taskService = ProcessEngines.getDefaultProcessEngine().getTaskService();
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected Form form;
    protected TextField nameField;
    protected TextArea descriptionArea;
    protected DateField dueDateField;
    protected PriorityComboBox priorityComboBox;
    protected Button createTaskButton;

    public NewCasePopupWindow() {
        this.setModal(true);
        this.center();
        this.setResizable(false);
        this.setCaption(this.i18nManager.getMessage("task.new"));
        this.addStyleName("light");
        this.setWidth(430.0f, 0);
        this.setHeight(320.0f, 0);
        this.initForm();
        this.initCreateTaskButton();
        this.initEnterKeyListener();
    }

    protected void initForm() {
        this.form = new Form();
        this.form.setValidationVisibleOnCommit(true);
        this.form.setImmediate(true);
        this.addComponent((Component)this.form);
        this.nameField = new TextField(this.i18nManager.getMessage("task.name"));
        this.nameField.focus();
        this.nameField.setRequired(true);
        this.nameField.setRequiredError(this.i18nManager.getMessage("task.name.required"));
        this.form.addField((Object)"name", (Field)this.nameField);
        this.descriptionArea = new TextArea(this.i18nManager.getMessage("task.description"));
        this.descriptionArea.setColumns(25);
        this.form.addField((Object)"description", (Field)this.descriptionArea);
        this.dueDateField = new DateField(this.i18nManager.getMessage("task.duedate"));
        this.dueDateField.setResolution(4);
        this.form.addField((Object)"duedate", (Field)this.dueDateField);
        this.priorityComboBox = new PriorityComboBox(this.i18nManager);
        this.form.addField((Object)"priority", (Field)this.priorityComboBox);
    }

    protected void initCreateTaskButton() {
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setWidth(100.0f, 8);
        this.form.getFooter().setWidth(100.0f, 8);
        this.form.getFooter().addComponent((Component)buttonLayout);
        Button createButton = new Button(this.i18nManager.getMessage("button.create"));
        buttonLayout.addComponent((Component)createButton);
        buttonLayout.setComponentAlignment((Component)createButton, Alignment.BOTTOM_RIGHT);
        createButton.addListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                NewCasePopupWindow.this.handleFormSubmit();
            }
        });
    }

    protected void initEnterKeyListener() {
        this.addActionHandler(new Action.Handler(){

            public void handleAction(Action action, Object sender, Object target) {
                NewCasePopupWindow.this.handleFormSubmit();
            }

            public Action[] getActions(Object target, Object sender) {
                return new Action[]{new ShortcutAction("enter", 13, null)};
            }
        });
    }

    protected void handleFormSubmit() {
        try {
            this.form.commit();
            Task task = this.taskService.newTask();
            task.setName(this.nameField.getValue().toString());
            task.setDescription(this.descriptionArea.getValue().toString());
            task.setDueDate((Date)this.dueDateField.getValue());
            task.setPriority(this.priorityComboBox.getPriority());
            task.setOwner(ExplorerApp.get().getLoggedInUser().getId());
            this.taskService.saveTask(task);
            this.close();
            ExplorerApp.get().getViewManager().showTasksPage(task.getId());
        }
        catch (Validator.InvalidValueException e) {
            this.setHeight(350.0f, 0);
        }
    }
}

